/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.googleAuth;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.QRCodeUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetGoogleAuthParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GoogleAuthResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Random;
import org.apache.commons.codec.binary.Base32;

public class GenerateGoogleAuthSecretKeyProcessor
extends BaseProcessor {
    private static final String OTP_AUTH_HOTP_URI_BASE = "otpauth://hotp/%s?secret=%s";
    private static final String IBE_CORP = "IBE-CORP";
    private static final String DEFAULT_USER_NAME = "(user)";

    public void process(MessageContext ctx) throws Exception {
        GetGoogleAuthParameters params = (GetGoogleAuthParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String secretKey = this.generateSecretkey();
        String loginName = this.getLoginName(params.getEmployeeRef(), params.getUserLogin());
        BinaryData image = this.getAuthImage(IBE_CORP, loginName, secretKey);
        GoogleAuthResult result = new GoogleAuthResult();
        result.setAuthToken(secretKey);
        result.setQrImage(image);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private BinaryData getAuthImage(String issuer, String accountName, String secretKey) throws Exception {
        BinaryData result = new BinaryData();
        String qr = this.getOtpAuthTotpURL(issuer, accountName, secretKey);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            QRCodeUtil.generateToStream((String)qr, (int)200, (int)200, (OutputStream)baos, (QRCodeUtil.ImageFormat)QRCodeUtil.ImageFormat.PNG);
            result.setData(baos.toByteArray());
            result.setContentType(ContentType.PNG);
        }
        return result;
    }

    private String getOtpAuthTotpURL(String issuer, String accountName, String secretKey32) throws UnsupportedEncodingException {
        return String.format(OTP_AUTH_HOTP_URI_BASE, this.formatLabel(issuer, accountName), secretKey32) + this.formatIssuerParameter(issuer);
    }

    private String getLoginName(String employeeRef, String userLogin) {
        EntityContainer personCtr;
        String loginName = userLogin;
        if (!TextUtil.isBlank((String)employeeRef) && (personCtr = EntityStorage.get().load(Person.class, employeeRef)) != null) {
            loginName = ((Person)personCtr.getEntity()).getLoginName();
        }
        return TextUtil.nonBlank((String)loginName) ? loginName : DEFAULT_USER_NAME;
    }

    private String generateSecretkey() {
        byte[] b = new byte[10];
        new Random().nextBytes(b);
        return new Base32().encodeToString(b);
    }

    private String internalURLEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    private String formatLabel(String issuer, String accountName) throws UnsupportedEncodingException {
        if (TextUtil.isBlank((String)accountName)) {
            throw new IllegalArgumentException("Account name must not be empty.");
        }
        StringBuilder sb = new StringBuilder();
        if (issuer != null) {
            if (issuer.contains(":")) {
                throw new IllegalArgumentException("Issuer cannot contain the ':' character.");
            }
            sb.append(this.internalURLEncode(issuer));
            sb.append(":");
        }
        sb.append(this.internalURLEncode(accountName));
        return sb.toString();
    }

    private String formatIssuerParameter(String issuer) throws UnsupportedEncodingException {
        if (issuer != null) {
            if (issuer.contains(":")) {
                throw new IllegalArgumentException("Issuer cannot contain the ':' character.");
            }
            return String.format("&issuer=%s", this.internalURLEncode(issuer));
        }
        return "";
    }
}

