/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.old.getBalancesCompany;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetBalancesCompanyResultSummary;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.old.BalanceCompanyReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.old.GetBalancesCompanyParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.old.GetBalancesCompanyResult;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.joda.time.DateTime;

public class GetBalancesCompanyProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer authorizedAgentCtr;
        Person authorizedAgent;
        EntityReference<Organization> agencyRef;
        GetBalancesCompanyParameters request = (GetBalancesCompanyParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Locale locale = LocaleHelper.getCurrentLocale();
        int limit = 0;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 100", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        }
        if ((agencyRef = CabinetHelper.findPlaceOFWorkReferenceOld(authorizedAgent = (Person)(authorizedAgentCtr = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER))).getEntity())) == null) {
            throw Xeption.forDeveloper((String)"No agency found for agent profile", (Object[])new Object[0]);
        }
        EntityReference<Organization> supplierAgencyRef = AuthorizationHelper.isCorporantAuthorizedOld(authorizedAgent) ? CabinetHelper.findAgencyReferenceOld(authorizedAgent) : CommonHelper.findMainAgency();
        GetBalancesCompanyResult result = new GetBalancesCompanyResult();
        result.setSummary(new GetBalancesCompanyResultSummary());
        ArrayList searchResultIndices = new ArrayList();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), agencyRef));
        if (request.getStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)MiscUtil.clearTime((Date)request.getStartDate().toDate())));
        }
        if (request.getEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)MiscUtil.setDayEndTime((Date)request.getEndDate().toDate())));
        }
        if (!TextUtil.isBlank((String)request.getPattern())) {
            String pattern = "%" + request.getPattern() + "%";
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)(BillingTransactionIndex.Property.referencedEntity.name() + "ReferenceCaption"), (String)pattern), SearchCriterion.ilike((String)BillingTransactionIndex.Property.description.name(), (String)pattern)}));
        }
        if (request.getCategory() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.category.name(), (Object)BillingTransactionCategory.valueOf((String)request.getCategory())));
        }
        searchResultIndices.addAll(EntityStorage.get().search(BillingTransactionIndex.class, query).getData());
        Collections.sort(searchResultIndices, CabinetHelper.createBalancesComparator());
        NumberFormat nf = CabinetHelper.getNumberFormat(locale);
        BigDecimal debitSum = BigDecimal.ZERO;
        BigDecimal creditSum = BigDecimal.ZERO;
        result.getSummary().setCount(String.valueOf(searchResultIndices.size()));
        for (BillingTransactionIndex balInd : searchResultIndices) {
            BalanceCompanyReference balanceRef = new BalanceCompanyReference();
            if (balInd.getTransactionDate() != null) {
                DateTime dt = new DateTime((Object)balInd.getTransactionDate());
                balanceRef.setBookingDate(dt);
            }
            if (balInd.getCategory() == BillingTransactionCategory.CREDIT) {
                creditSum = creditSum.add(CurrencyHelper.exchange((BigDecimal)balInd.getTransactionSum(), agencyRef));
            }
            if (balInd.getCategory() == BillingTransactionCategory.DEBIT) {
                debitSum = debitSum.add(CurrencyHelper.exchange((BigDecimal)balInd.getTransactionSum(), agencyRef));
            }
            balanceRef.setBookingNumber(CabinetHelper.getBookingNumber(balInd));
            if (balInd.getCategory() != null) {
                balanceRef.setOperationType(balInd.getCategory().toString());
                if (balInd.getCategory() == BillingTransactionCategory.CREDIT) {
                    balanceRef.setOutcome(nf.format(CurrencyHelper.exchange((BigDecimal)balInd.getTransactionSum(), agencyRef)));
                    balanceRef.setIncome("");
                } else {
                    balanceRef.setIncome(nf.format(CurrencyHelper.exchange((BigDecimal)balInd.getTransactionSum(), agencyRef)));
                    balanceRef.setOutcome("");
                }
            }
            balanceRef.setNotes(balInd.getDescription());
            if (balInd.getClient() != null) {
                balanceRef.setCompany(balInd.getClient().getCaption());
            }
            if (balInd.getAgent() != null) {
                balanceRef.setAgent(balInd.getAgent().getCaption());
            }
            result.getBalancesCompany().add(balanceRef);
            if (result.getBalancesCompany().size() != limit) continue;
            break;
        }
        result.getSummary().setDebitSum(nf.format(debitSum));
        result.getSummary().setCreditSum(nf.format(creditSum));
        if (supplierAgencyRef != null) {
            ContractType balanceContractType = AuthorizationHelper.isCorporantAuthorizedOld(authorizedAgent) ? ContractType.CLIENT : ContractType.SUBAGENCY;
            BigDecimal balance = BillingTransactionHelper.calculateBillingTransactionsSum((ContractType)balanceContractType, agencyRef, supplierAgencyRef, null, null, null, (Date)(request.getStartDate() != null ? request.getStartDate().toDate() : null), request.getEndDate() != null ? request.getEndDate().toDate() : null);
            BigDecimal credit = ProfileHelper.getOrganizationCreditAmount(agencyRef, supplierAgencyRef);
            if (balance != null) {
                if (credit != null) {
                    result.setAvailableFunds(nf.format(CurrencyHelper.exchange((BigDecimal)balance, agencyRef).add(CurrencyHelper.exchange((BigDecimal)credit, agencyRef))));
                    result.setAvailableFundsSubagent(nf.format(balance.add(credit)));
                } else {
                    result.setAvailableFunds(nf.format(CurrencyHelper.exchange((BigDecimal)balance, agencyRef)));
                    result.setAvailableFundsSubagent(nf.format(balance));
                }
                result.setAvailableFundsCurrency((String)MiscUtil.findByLocale((Map)DictHelper.getCurrencyInfoByAnyCode((String)CurrencyHelper.getClientCurrencyForCurrentSubagent(agencyRef)).getTranslations(), (Locale)locale));
                result.setAvailableFundsSubagentCurrency((String)MiscUtil.findByLocale((Map)DictHelper.getCurrencyInfoByAnyCode((String)CurrencyHelper.getSubagentCurrencyForSubagent(agencyRef)).getTranslations(), (Locale)locale));
                result.setOwnFunds(nf.format(CurrencyHelper.exchange((BigDecimal)balance, agencyRef)));
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

