/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.old.getProducts;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.GetProductsResultSummary;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.old.GetProductsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.old.GetProductsResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.old.ProductReference;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class GetProductsProcessor
extends BaseProcessor {
    private static int compareNumbers(String o1, String o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer perCont;
        Person loginAgent;
        EntityReference<Organization> agencyRef;
        GetProductsParameters request = (GetProductsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Locale locale = LocaleHelper.getCurrentLocale();
        int limit = 0;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 100", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        }
        if ((agencyRef = CabinetHelper.findAgencyReferenceOld(loginAgent = (Person)(perCont = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER))).getEntity())) == null) {
            throw Xeption.forDeveloper((String)"No agency found for agent profile", (Object[])new Object[0]);
        }
        GetProductsResult result = new GetProductsResult();
        result.setSummary(new GetProductsResultSummary());
        NumberFormat df = CabinetHelper.getNumberFormat(locale);
        ArrayList searchResultIndices = new ArrayList();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), agencyRef));
        boolean hasCreatedOrdersForQuery = false;
        if (request.getStartDate() != null || request.getEndDate() != null) {
            SearchQuery queryBookingFiles = new SearchQuery();
            if (request.getStartDate() != null) {
                queryBookingFiles.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.createDate.name(), (Object)MiscUtil.clearTime((Date)request.getStartDate().toDate())));
            }
            if (request.getEndDate() != null) {
                queryBookingFiles.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.createDate.name(), (Object)MiscUtil.setDayEndTime((Date)request.getEndDate().toDate())));
            }
            queryBookingFiles.getCriteria().getCriterions().add(SearchCriterion.ne((String)BookingFileIndex.Property.site.name(), null));
            List bookingRefs = StorageHelper.getEntityReferences((SearchQuery)queryBookingFiles, BookingFileIndex.class);
            if (!bookingRefs.isEmpty()) {
                hasCreatedOrdersForQuery = true;
                List<String> bookingNumbers = bookingRefs.stream().map(EntityReference::getCaption).collect(Collectors.toList());
                query.getCriteria().getCriterions().add(SearchCriterion.in((String)ProductIndex.Property.bookingNumber.name(), (Object[])bookingNumbers.toArray(new String[bookingNumbers.size()])));
            } else {
                ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
                return;
            }
        }
        if (!TextUtil.isBlank((String)request.getBlankOwnerCode())) {
            SearchQuery queryBlankOwners = new SearchQuery();
            queryBlankOwners.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
            queryBlankOwners.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)request.getBlankOwnerCode()));
            List blankRefs = ProfileDao.getProfileReferences((SearchQuery)queryBlankOwners, OrganizationIndex.class);
            if (blankRefs.isEmpty()) {
                throw Xeption.forDeveloper((String)("No blank owner found for given code: " + request.getBlankOwnerCode()), (Object[])new Object[0]);
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), blankRefs.get(0)));
        }
        if (request.getAirline() != null) {
            Airline carrier = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(request.getAirline());
            if (carrier == null) {
                throw Xeption.forDeveloper((String)("No airline found for given code: " + request.getAirline()), (Object[])new Object[0]);
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.carrierNumber.name(), (Object)carrier.getAirlineNumber()));
        }
        if (!TextUtil.isBlank((String)request.getAgentContainerUid())) {
            SearchQuery queryAgent = new SearchQuery();
            queryAgent.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)(AuthorizationHelper.isCorporantAuthorizedOld(loginAgent) ? PersonType.PASSENGER.name() : PersonType.AGENT.name())));
            queryAgent.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)request.getAgentContainerUid()));
            List agentRefs = ProfileDao.getProfileReferences((SearchQuery)queryAgent, PersonIndex.class);
            if (agentRefs.isEmpty()) {
                throw Xeption.forDeveloper((String)("No agent found for given container uid: " + request.getAgentContainerUid()), (Object[])new Object[0]);
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agent.name(), agentRefs.get(0)));
        }
        if (request.getStatus() != null) {
            ProductStatus status = request.getStatus();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)status));
        }
        if (!TextUtil.isBlank((String)request.getPattern())) {
            String pattern = "%" + request.getPattern() + "%";
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)ProductIndex.Property.ticketNumbers.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.bookingNumber.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.carrierName.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.travellerName.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.recordLocators.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.recordLocator.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.routeCities.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.routeLine.name(), (String)pattern), SearchCriterion.ilike((String)ProductIndex.Property.routeLineCodes.name(), (String)pattern)}));
        }
        if (AuthorizationHelper.isCorporantAuthorizedOld(loginAgent)) {
            EntityReference<Organization> clientRef = CabinetHelper.findPlaceOFWorkReferenceOld(loginAgent);
            if (clientRef == null) {
                throw Xeption.forDeveloper((String)("No corporate client found for agent: " + loginAgent), (Object[])new Object[0]);
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.client.name(), clientRef));
        }
        query = AclHelper.modifyQuery((SearchQuery)query, (String)ProductIndex.class.getName(), (String)loginAgent.getLoginName(), Collections.emptyList());
        String grantedLogin = CabinetHelper.findGrantedLoginOld(loginAgent);
        boolean granted = AclHelper.isGranted(null, (String)ProductIndex.class.getName(), (String)grantedLogin, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList());
        if (!granted) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", null));
        }
        if (request.isWithSummary() != null && request.isWithSummary().booleanValue()) {
            query.setResultMode(ResultMode.COUNT_ONLY);
            result.getSummary().setCount(EntityStorage.get().search(ProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getTotalCount());
            ProjectionQuery projectionQuery = new ProjectionQuery();
            projectionQuery.getCriteria().getCriterions().addAll(query.getCriteria().getCriterions());
            projectionQuery.getProjections().add(Projection.sum((String)ProductIndex.Property.totalSum.name(), (String)"totalSumResult"));
            if (!AuthorizationHelper.isCorporantAuthorizedOld(loginAgent)) {
                projectionQuery.getProjections().add(Projection.sum((String)ProductIndex.Property.income.name(), (String)"incomeSumResult"));
            }
            ProjectionResult productSummary = EntityStorage.get().search(ProductIndex.class, projectionQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
            BigDecimal totalSumResult = productSummary.getBigDecimal("totalSumResult");
            if (!AuthorizationHelper.isCorporantAuthorizedOld(loginAgent)) {
                BigDecimal incomeSumResult = productSummary.getBigDecimal("incomeSumResult");
                result.getSummary().setIncomeSum(df.format(incomeSumResult));
            }
            result.getSummary().setAmountSum(df.format(totalSumResult));
        }
        query.setResultMode(ResultMode.DATA_ONLY);
        if (request.getPageSize() != null) {
            query.setLimit(request.getPageSize().intValue());
            if (request.getPage() != null) {
                query.setOffset(request.getPage() * request.getPageSize());
            }
        }
        searchResultIndices.addAll(hasCreatedOrdersForQuery ? EntityStorage.get().search(ProductIndex.class, query).getData() : new LinkedList());
        Collections.sort(searchResultIndices, this.createProductsComparator());
        HashMap<DictionaryReference, String> airlineNames = new HashMap<DictionaryReference, String>();
        HashMap<DictionaryReference, Airline> airlineMap = new HashMap<DictionaryReference, Airline>();
        for (ProductIndex prodInd : searchResultIndices) {
            ProductReference prodRef = new ProductReference();
            prodRef.setProductUid(prodInd.getNavigationKey());
            prodRef.setBookingNumber(prodInd.getBookingNumber());
            if (prodInd.getIssueDate() != null) {
                prodRef.setBookingDate(new DateTime((Object)prodInd.getIssueDate()));
            }
            if (prodInd.getClient() != null) {
                EntityContainer client = EntityStorage.get().resolve(prodInd.getClient());
                if (client != null) {
                    prodRef.setClient((String)MiscUtil.findByLocale((Map)((Organization)client.getEntity()).getShortName().getValues(), (Locale)locale));
                } else {
                    prodRef.setClient(prodInd.getClient().getCaption());
                }
            }
            if (prodInd.getAgent() != null) {
                EntityContainer agent = EntityStorage.get().resolve(prodInd.getAgent());
                String lastName = TextUtil.nonNullStr((String)((String)MiscUtil.findByLocale((Map)((Person)agent.getEntity()).getLastName().getValues(), (Locale)locale)));
                String firstName = TextUtil.nonNullStr((String)((String)MiscUtil.findByLocale((Map)((Person)agent.getEntity()).getFirstName().getValues(), (Locale)locale)));
                prodRef.setAgent(lastName + " " + firstName);
            }
            prodRef.setTypeOfService(LocaleUtil.LOCALE_RU.equals(locale) ? "\u0410\u0432\u0438\u0430" : "Air");
            if (prodInd.getBlankOwner() != null) {
                EntityContainer blankOwner = EntityStorage.get().resolve(prodInd.getBlankOwner());
                prodRef.setBlankOwner((String)MiscUtil.findByLocale((Map)((Organization)blankOwner.getEntity()).getShortName().getValues(), (Locale)locale));
            }
            if (prodInd.getCarrier() != null) {
                Airline airline;
                if (airlineNames.containsKey(prodInd.getCarrier())) {
                    airline = DictHelper.findAirlineByAnyCode((String)prodInd.getCarrier().getCode());
                    prodRef.setAirline((String)MiscUtil.findByLocale((Map)airline.getTranslations(), (Locale)locale));
                } else {
                    airline = (Airline)DictionaryCache.get().resolveReference(prodInd.getCarrier());
                    if (airline != null) {
                        String airName = (String)MiscUtil.findByLocale((Map)airline.getTranslations(), (Locale)locale);
                        prodRef.setAirline(airName);
                        airlineNames.put(prodInd.getCarrier(), airName);
                        airlineMap.put(prodInd.getCarrier(), airline);
                    }
                }
            }
            if (!TextUtil.isBlank((String)prodInd.getRouteLineCodes())) {
                StringBuilder sb = new StringBuilder();
                Iterator<String> it = Arrays.asList(prodInd.getRouteLineCodes().split("//")).iterator();
                while (it.hasNext()) {
                    String seg = it.next().trim();
                    Iterator<String> itSeg = Arrays.asList(seg.split("-")).iterator();
                    while (itSeg.hasNext()) {
                        GeoLocation city = DictHelper.findCityByCode((String)itSeg.next().trim(), (CodeSystem)CodeSystem.IATA);
                        sb.append((String)MiscUtil.findByLocale((Map)city.getTranslations(), (Locale)locale));
                        if (!itSeg.hasNext()) continue;
                        sb.append(" - ");
                    }
                    if (!it.hasNext()) continue;
                    sb.append("//");
                }
                prodRef.setRoute(sb.toString());
            }
            if (prodInd.getFirstFlightDate() != null) {
                prodRef.setDepartureDate(new DateTime((Object)prodInd.getFirstFlightDate()));
            }
            prodRef.setTraveler(prodInd.getTravellerName());
            if (prodInd.getTotalSum() != null) {
                prodRef.setAmount(df.format(prodInd.getTotalSum()));
            }
            if (prodInd.getClientFeeRate() != null) {
                prodRef.setFees(df.format(prodInd.getClientFeeRate()));
            }
            if (prodInd.getStatus() != null) {
                prodRef.setStatus(MetaRegistryHelper.getDisplayName(ProductStatus.class, (String)prodInd.getStatus().name(), (Locale)locale));
            }
            if (!prodInd.getTicketNumbers().isEmpty()) {
                String ticketNumber = (String)prodInd.getTicketNumbers().iterator().next();
                if (prodInd.getCarrier() != null && airlineMap.containsKey(prodInd.getCarrier())) {
                    ticketNumber = ((Airline)airlineMap.get(prodInd.getCarrier())).getAirlineNumber() + ticketNumber;
                }
                prodRef.setTicketNumber(ticketNumber);
            }
            if (TextUtil.nonBlank((String)prodInd.getDisplayedRecordLocator())) {
                prodRef.setPnr(prodInd.getDisplayedRecordLocator());
            } else {
                prodRef.setPnr(prodInd.getRecordLocator());
            }
            if (!TextUtil.isBlank((String)prodInd.getNotes())) {
                prodRef.setNotes(prodInd.getNotes());
            }
            if (!AuthorizationHelper.isCorporantAuthorizedOld(loginAgent) && prodInd.getIncome() != null) {
                prodRef.setIncome(df.format(prodInd.getIncome()));
            }
            if (prodInd.getTimelimit() != null) {
                prodRef.setTimelimit(new DateTime((Object)prodInd.getTimelimit()));
            }
            if (prodInd.getWarningAboutExpiring() != null) {
                prodRef.setWarningAboutExpiring(new DateTime((Object)prodInd.getWarningAboutExpiring()));
            }
            result.getProducts().add(prodRef);
            if (result.getProducts().size() != limit) continue;
            break;
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private Comparator<ProductIndex> createProductsComparator() {
        return (o1, o2) -> {
            int result = GetProductsProcessor.compareNumbers(o1.getBookingNumber(), o2.getBookingNumber());
            if (result == 0 && o1.getTicketNumbers().size() > 0 && o2.getTicketNumbers().size() > 0) {
                result = GetProductsProcessor.compareNumbers((String)o1.getTicketNumbers().iterator().next(), (String)o2.getTicketNumbers().iterator().next());
            }
            return result;
        };
    }
}

