/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.registerCabinetHolder;

import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RegisterCabinetHolderParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RegisterCabinetHolderValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.PersonValidationMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;

public class RegisterCabinetHolderValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RegisterCabinetHolderParameters parameters = (RegisterCabinetHolderParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)parameters.getLogin()) || !CommonValidationHelper.isValidEmailFormat(parameters.getLogin())) {
            parameters.getValidationContext().getLoginValidationMessages().add(PersonValidationMessages.getInvalidEmail());
        } else {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)parameters.getLogin()));
            query.setResultMode(ResultMode.COUNT_ONLY);
            if (EntityStorage.get().search(PersonIndex.class, query).getTotalCount() > 0) {
                parameters.getValidationContext().getLoginValidationMessages().add(RegisterCabinetHolderValidationMessages.getLoginAlreadyExists());
            }
        }
        if (TextUtil.isBlank((String)parameters.getPassword())) {
            parameters.getValidationContext().getPasswordValidationMessages().add(PersonValidationMessages.getIncorrectPassword());
        } else if (!parameters.getPassword().equals(parameters.getPasswordConformation())) {
            parameters.getValidationContext().getPasswordValidationMessages().add(PersonValidationMessages.getPasswordMismatch());
            parameters.getValidationContext().getPasswordConformationValidationMessages().add(PersonValidationMessages.getPasswordMismatch());
        } else {
            CommonValidationHelper.validatePasswordPolicy(parameters.getPassword(), parameters.getValidationContext().getPasswordValidationMessages());
        }
        if (!parameters.isAcceptRules()) {
            parameters.getValidationContext().getAcceptRulesValidationMessages().add(RegisterCabinetHolderValidationMessages.getRulesNotAccepted());
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }
}

