/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.updateCabinetHolder;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthToken;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.SecurityType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.fx.rpc.service.AuthServiceImpl;
import com.gridnine.xtrip.server.ibecorp.assets.UserSecurityTokenAsset;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateCabinetHolderParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.UpdateCabinetHolderResult;
import com.gridnine.xtrip.server.ibecorp.helpers.UserSecurityHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.security.GeneralSecurityException;
import javax.servlet.http.Cookie;

public class UpdateCabinetHolderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer personCtr = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER));
        UpdateCabinetHolderParameters params = (UpdateCabinetHolderParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        Person user = (Person)personCtr.getEntity();
        boolean isB2C = siteType == SMSiteType.B2C;
        Employee restEmployee = params.getHolder();
        UserAccount userAccount = CabinetHelper.updateUserAccount(restEmployee, user);
        if (userAccount != null) {
            if (!userAccount.isActive()) {
                throw new GeneralSecurityException(String.format("user %s is inactive", user.getLoginName()));
            }
            if (TextUtil.nonBlank((String)restEmployee.getSystemAccess().getPassword())) {
                String authToken = (String)((Object)new AuthServiceImpl().login(null, user.getLoginName(), restEmployee.getSystemAccess().getPassword().toCharArray(), isB2C));
                Cookie authTokenCookie = new Cookie("IBECORP_B2B_AUTH_TOKEN_COOKIE", "");
                authTokenCookie.setPath("/");
                authTokenCookie.setMaxAge(-1);
                authTokenCookie.setValue(new AuthToken(authToken, 30).encode());
                RestContext context = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
                context.getResponse().addCookie(authTokenCookie);
                ctx.putObject((Enum)IBusIbecorpContextKeys.UPDATE_TOKEN, (Object)Boolean.FALSE);
            }
        }
        CabinetConverterHelper.updateRestEmployee2Person(restEmployee, user, false, isB2C, true);
        LogicalStorageHelper.unitOfWork(() -> {
            if (userAccount != null) {
                AssetsStorage.get().save((BaseAsset)userAccount, true);
            }
            personCtr.getVersionInfo().setDataSource("Site");
            if (IntegrationBusHelper.getThreadContext() != null) {
                personCtr.getVersionInfo().setVersionNotes(IntegrationBusHelper.getThreadContext().getRouteId());
            } else {
                personCtr.getVersionInfo().setVersionNotes("ROUT_NOT_FOUND");
            }
            EntityStorage.get().save(personCtr, true);
            if (params.getHolder().getSecurityType() == SecurityType.GOOGLE && TextUtil.nonBlank((String)params.getHolder().getGoogleAuthToken())) {
                UserSecurityTokenAsset userSecurityTokenAsset = UserSecurityHelper.findOrCreateUserSecurityTokenAsset(personCtr.getUid());
                UserSecurityHelper.setGoogleAuthToken(userSecurityTokenAsset, params.getHolder().getGoogleAuthToken());
                AssetsStorage.get().save((BaseAsset)userSecurityTokenAsset);
            }
        });
        UpdateCabinetHolderResult result = new UpdateCabinetHolderResult();
        result.setUpdated(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

