/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.updateEmployee;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.SecurityType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.ibecorp.assets.UserSecurityTokenAsset;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateEmployeeParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateEmployeeResult;
import com.gridnine.xtrip.server.ibecorp.helpers.UserSecurityHelper;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import org.apache.commons.lang.StringUtils;

public class UpdateEmployeeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UpdateEmployeeParameters params = (UpdateEmployeeParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Employee restEmployee = params.getEmployee();
        EntityContainer personCtr = EntityStorage.get().resolve(new EntityReference(restEmployee.getUid(), Person.class, null));
        if (personCtr == null) {
            throw Xeption.forDeveloper((String)String.format("Employee with containerUid %s is not found", restEmployee.getUid()), (Object[])new Object[0]);
        }
        if (!IbePermissionManager.isEntityGranted(personCtr, StandardRestrictionResourceOperations.EDIT)) {
            throw Xeption.forDeveloper((String)("update Person is not granted for user " + UserData.get().getCurrentUser()), (Object[])new Object[0]);
        }
        CabinetConverterHelper.updateRestEmployee2Person(restEmployee, (Person)personCtr.getEntity(), false);
        MiscUtil.Pair<UserAccount, AclUser> pair = this.updateEmployeeAccount((Person)personCtr.getEntity(), restEmployee);
        LogicalStorageHelper.unitOfWork(() -> {
            if (pair != null && pair.getFirst() != null) {
                AssetsStorage.get().save((BaseAsset)pair.getFirst());
            }
            if (pair != null && pair.getSecond() != null) {
                AssetsStorage.get().save((BaseAsset)pair.getSecond());
            }
            if (params.getEmployee().getSecurityType() == SecurityType.GOOGLE && TextUtil.nonBlank((String)params.getEmployee().getGoogleAuthToken())) {
                UserSecurityTokenAsset userSecurityTokenAsset = UserSecurityHelper.findOrCreateUserSecurityTokenAsset(personCtr.getUid());
                UserSecurityHelper.setGoogleAuthToken(userSecurityTokenAsset, params.getEmployee().getGoogleAuthToken());
                AssetsStorage.get().save((BaseAsset)userSecurityTokenAsset);
            }
            personCtr.getVersionInfo().setDataSource("Site");
            if (IntegrationBusHelper.getThreadContext() != null) {
                personCtr.getVersionInfo().setVersionNotes(IntegrationBusHelper.getThreadContext().getRouteId());
            } else {
                personCtr.getVersionInfo().setVersionNotes("ROUT_NOT_FOUND");
            }
            EntityStorage.get().save(personCtr, true);
        });
        UpdateEmployeeResult result = new UpdateEmployeeResult();
        result.setUpdated(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private MiscUtil.Pair<UserAccount, AclUser> updateEmployeeAccount(Person person, Employee restEmployee) throws Exception {
        MiscUtil.Pair pair = null;
        if (StringUtils.isNotBlank((String)person.getLoginName())) {
            UserAccount updatedAccount;
            if (CabinetHelper.updateUserAccountGranted() && (updatedAccount = CabinetHelper.updateUserAccount(restEmployee, person)) != null) {
                pair = new MiscUtil.Pair();
                pair.setFirst((Object)updatedAccount);
            }
        } else {
            pair = CabinetHelper.createUserAccount(person, restEmployee);
        }
        return pair;
    }
}

