/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.updateEmployee;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.SecurityType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetValidationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.SystemAccessValidationMessages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateEmployeeParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import org.apache.commons.lang.StringUtils;

public class UpdateEmployeeValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UpdateEmployeeParameters params = (UpdateEmployeeParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer userCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        EntityContainer personCtr = EntityStorage.get().resolve(new EntityReference(params.getEmployee().getUid(), Person.class, null));
        Person person = (Person)personCtr.getEntity();
        if (params.getEmployee().getSystemAccess() != null) {
            String login = params.getEmployee().getSystemAccess().getLogin();
            if (StringUtils.isNotBlank((String)login)) {
                if (!CabinetHelper.updateUserAccountGranted()) {
                    throw Xeption.forEndUser((String)"ERROR_UPDATE_ACCESS_PARAMETERS_NOT_ALLOWED", (Object[])new Object[0]);
                }
                if (StringUtils.isBlank((String)person.getLoginName())) {
                    CabinetValidationHelper.systemAccessCreateValidation(params.getEmployee());
                } else {
                    CabinetValidationHelper.validateEmployeeEmail(params.getEmployee());
                }
            } else if (StringUtils.isNotBlank((String)params.getEmployee().getSystemAccess().getPassword())) {
                params.getEmployee().getSystemAccess().getValidationContext().getLoginValidationMessages().add(SystemAccessValidationMessages.getMissingLogin());
            }
        }
        CabinetValidationHelper.validateEmployee(params.getEmployee(), salesContext, (EntityContainer<Person>)personCtr, (Person)userCtr.getEntity());
        if (params.getEmployee().getSecurityType() == SecurityType.GOOGLE && person.getSecurityType() != SecurityType.GOOGLE && TextUtil.isBlank((String)params.getEmployee().getGoogleAuthToken())) {
            params.getEmployee().getValidationContext().getGoogleAuthTokenValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (!ValidationHelper.isValid((Validatable)params.getEmployee())) {
            throw new ValidationException();
        }
    }
}

