/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.updatePassenger;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdatePassengerParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdatePassengerResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;

public class UpdatePassengerProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UpdatePassengerParameters parameters = (UpdatePassengerParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)parameters.getPassenger().getUid()));
        EntityStorage entityStorage = EntityStorage.get();
        List personIndexes = entityStorage.search(PersonIndex.class, searchQuery).getData();
        UpdatePassengerResult result = new UpdatePassengerResult();
        if (!personIndexes.isEmpty()) {
            EntityContainer personCtr = EntityStorage.get().resolve(((PersonIndex)personIndexes.get(0)).getSource());
            if (IntegrationBusHelper.getThreadContext() != null) {
                if (IntegrationBusHelper.getThreadContext().getRouteId().equals("ibecorp:b2b:cabinet:update-passenger")) {
                    personCtr.getVersionInfo().setDataSource("Site B2B");
                    personCtr.getVersionInfo().setVersionNotes("ibecorp:b2b:cabinet:update-passenger");
                } else if (IntegrationBusHelper.getThreadContext().getRouteId().equals("ibecorp:b2c:cabinet:update-passenger")) {
                    personCtr.getVersionInfo().setDataSource("Site B2C");
                    personCtr.getVersionInfo().setVersionNotes("ibecorp:b2c:cabinet:update-passenger");
                } else if (IntegrationBusHelper.getThreadContext().getRouteId().equals("ibecorp:b2b:cabinet:create-passenger")) {
                    personCtr.getVersionInfo().setDataSource("Site B2B");
                    personCtr.getVersionInfo().setVersionNotes("ibecorp:b2b:cabinet:create-passenger");
                } else if (IntegrationBusHelper.getThreadContext().getRouteId().equals("ibecorp:b2c:cabinet:create-passenger")) {
                    personCtr.getVersionInfo().setDataSource("Site B2C");
                    personCtr.getVersionInfo().setVersionNotes("ibecorp:b2c:cabinet:create-passenger");
                } else {
                    personCtr.getVersionInfo().setDataSource("Site");
                    personCtr.getVersionInfo().setVersionNotes("ROUT_NOT_FOUND");
                }
            }
            CabinetConverterHelper.updateRest2Person(parameters.getPassenger(), (Person)personCtr.getEntity());
            entityStorage.save(personCtr, true);
            result.setUpdated(true);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

