/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.updateRuleGroup;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RuleGroupResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateRuleGroupParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class UpdateRuleGroupProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UpdateRuleGroupParameters params = (UpdateRuleGroupParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference modelContractRef = new EntityReference(params.getUid(), ModelContract.class, null);
        EntityContainer modelContractCtr = EntityStorage.get().resolve(modelContractRef);
        ModelContract modelContract = (ModelContract)modelContractCtr.getEntity();
        modelContract.setName(params.getName());
        modelContract.setPriority(params.getPriority());
        List ruleUids = params.getRuleUids();
        List rules = modelContract.getRuleSet().getRules();
        this.actualizeRules(ruleUids, rules);
        EntityStorage.get().save(modelContractCtr, true);
        RuleGroupResult result = new RuleGroupResult();
        result.setUid(modelContract.getUid());
        result.setName(modelContract.getName());
        result.setPriority(modelContract.getPriority());
        result.getRules().addAll(modelContract.getRuleSet().getRules().stream().map(CabinetConverterHelper::convertRule2Rest).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void actualizeRules(List<String> ruleUids, List<RuleSettings> rules) {
        HashMap<String, Integer> ruleUidsMap = new HashMap<String, Integer>(ruleUids.size());
        for (int position = 0; position < ruleUids.size(); ++position) {
            ruleUidsMap.put(ruleUids.get(position), position);
        }
        Collections.sort(rules, (rule1, rule2) -> {
            Integer rule1Position = (Integer)ruleUidsMap.get(rule1.getUid());
            Integer rule2Position = (Integer)ruleUidsMap.get(rule2.getUid());
            if (rule1Position == null && rule2Position == null) {
                return 0;
            }
            if (rule2Position == null) {
                return -1;
            }
            if (rule1Position == null) {
                return 1;
            }
            return Integer.compare(rule1Position, rule2Position);
        });
        if (ruleUids.size() < rules.size()) {
            rules.subList(ruleUids.size(), rules.size()).clear();
        }
    }
}

