/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.updateRuleSettings;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.UpdateRuleSettingsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BaseOperationResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BaseOperationStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.stream.Collectors;

public class UpdateRuleSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseOperationStatus status;
        UpdateRuleSettingsParameters parameters = (UpdateRuleSettingsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer modelContractCtr = EntityStorage.get().resolve(parameters.getRuleGroup());
        ModelContract modelContract = (ModelContract)modelContractCtr.getEntity();
        RuleSettings ruleSettings = CabinetHelper.findRuleSettings(modelContract, parameters.getRuleUid());
        if (ruleSettings == null) {
            ruleSettings = new RuleSettings();
            ruleSettings.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
            modelContract.getRuleSet().getRules().add(ruleSettings);
        }
        ruleSettings.setName(parameters.getName());
        ruleSettings.getRestrictions().clear();
        ruleSettings.getRestrictions().addAll(parameters.getRestrictions().stream().map(CabinetConverterHelper::convertRest2RuleRestriction).collect(Collectors.toList()));
        ruleSettings.getResults().clear();
        ruleSettings.getResults().addAll(parameters.getResults().stream().map(CabinetConverterHelper::convertRest2RuleResult).collect(Collectors.toList()));
        ruleSettings.setPeriodBegin(CabinetConverterHelper.convertRest2Date(parameters.getStartDate()));
        ruleSettings.setPeriodEnd(CabinetConverterHelper.convertRest2Date(parameters.getEndDate()));
        try {
            EntityStorage.get().save(modelContractCtr, true);
            status = BaseOperationStatus.SUCCESS;
        }
        catch (Exception e) {
            status = BaseOperationStatus.ERROR;
        }
        BaseOperationResult result = new BaseOperationResult();
        result.setStatus(status);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

