/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.common;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.http.HttpUtils;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.common.WebsiteHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.common.JsErrorReportParams;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsErrorReportProcessor
extends BaseProcessor {
    private static final String COOKIE_PARAMETER_OPERATION_ID = "X-ClientOperationId";
    private static final Logger log = LoggerFactory.getLogger(JsErrorReportProcessor.class);
    private static final String METRICS_PREFIX = "profiling.b2b.errors.";

    public void process(MessageContext ctx) throws Exception {
        JsErrorReportParams params = (JsErrorReportParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String userLogin = UserData.get().getCurrentUser();
        RestContext restContext = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        HttpServletRequest request = restContext.getRequest();
        StringBuilder sb = new StringBuilder();
        Stream.of("X-Reference", "X-Reference-History", "User-Agent").forEach(headerName -> {
            String header = request.getHeader(headerName);
            if (TextUtil.isBlank((String)header)) {
                sb.append('\n').append((String)headerName).append("=<>");
                return;
            }
            sb.append('\n').append((String)headerName).append("=<").append(header).append(">");
        });
        Optional<String> xOperationId = Optional.ofNullable(HttpUtils.find((HttpServletRequest)request, (String)COOKIE_PARAMETER_OPERATION_ID)).map(Cookie::getValue).filter(TextUtil::nonBlank);
        sb.append('\n').append(COOKIE_PARAMETER_OPERATION_ID).append("=<").append(xOperationId.orElse("")).append(">");
        Metrics.get().event("profiling.b2b.errors.all");
        String text = params.getText();
        if (Objects.isNull(text)) {
            text = "";
        }
        String userLoginText = "RestAuthCookieLogin=" + (Objects.isNull(userLogin) ? "<no_login>" : "<" + userLogin + ">");
        text = text + '\n' + userLoginText;
        if ((text = text + sb.toString()).startsWith("REDESIGN_SLOW_INTERNET_CONNECTION ")) {
            if (log.isWarnEnabled()) {
                log.warn(text);
            }
            Metrics.get().event("profiling.b2b.errors.slow-internet-connection");
            return;
        }
        if (text.startsWith("REDESIGN_SLOW_AJAX ")) {
            if (log.isWarnEnabled()) {
                log.warn(text);
            }
            Metrics.get().event("profiling.b2b.errors.slow-ajax");
            return;
        }
        RestContext restCtx = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        boolean oldBrowserWarningOverridden = WebsiteHelper.isBrowserCheckOverridden(restCtx.getRequest());
        if (text.startsWith("UNIDENTIFIABLE_SCRIPT_ERROR ")) {
            if (!oldBrowserWarningOverridden) {
                if (log.isErrorEnabled()) {
                    log.error(text);
                }
            } else if (log.isWarnEnabled()) {
                log.warn(text);
            }
            Metrics.get().event("profiling.b2b.errors.unidentifiable-script");
            return;
        }
        Metrics.get().event("profiling.b2b.errors.others");
        if (!oldBrowserWarningOverridden) {
            if (log.isErrorEnabled()) {
                log.error(text);
            }
            IncidentsLog.reportStackTrace((String)("js client error " + text));
        } else if (log.isWarnEnabled()) {
            log.warn(text);
        }
    }
}

