/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.download;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BookingDocumentReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardGetMethodParam;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;

public class DownloadBookingDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        StandardGetMethodParam param = (StandardGetMethodParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        TemporalObject to = (TemporalObject)AssetsStorage.get().load(TemporalObject.class, param.getUid());
        if (to == null) {
            throw Xeption.forEndUser((String)Messages.DOWNLOAD_TOKEN_INVALID_OR_EXPIRED, (Object[])new Object[0]);
        }
        BookingDocumentReference ref = new BookingDocumentReference();
        XUtil.fromBytes((byte[])to.getData(), (XSerializable)ref);
        BaseFileDocument document = DownloadBookingDocumentProcessor.findDocument(ref);
        DownloadableData data = new DownloadableData();
        data.setFileName(DocumentHelper.getDocNameWithExtension((BaseFileDocument)document));
        BinaryData bd = new BinaryData();
        bd.setContentType(ContentType.BINARY);
        byte[] content = document.getContentType() == ContentType.JASPERPRINT ? JasperUtil.convertToPdf((byte[])document.getContent()) : document.getContent();
        bd.setData(content);
        data.setContent(bd);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)data);
    }

    private static BaseFileDocument findDocument(BookingDocumentReference ref) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)new EntityReference(ref.getBookingFileUid(), BookingFile.class, null)));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)ref.getProductUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)ref.getDocumentType()));
        query.setLimit(2);
        List data = EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
        if (data.isEmpty()) {
            throw Xeption.forEndUser((String)Messages.DOWNLOAD_TOKEN_INVALID_OR_EXPIRED, (Object[])new Object[0]);
        }
        if (data.size() > 1) {
            throw Xeption.forDeveloper((String)"ambiguous document for owner {0}, navigationKey {1}, type {2}", (Object[])new Object[]{ref.getBookingFileUid(), ref.getProductUid(), ref.getDocumentType()});
        }
        return (BaseFileDocument)EntityStorage.get().resolve(((BasicDocumentIndex)data.get(0)).getSource()).getEntity();
    }
}

