/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.ibecorp.exception.DuplicatesExistsException;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductGuestIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.duplicates.DupesHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.AviaDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.DuplicatesCheckResult;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMBookingControlSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDupesHelper;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.IBusApprovalContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates.DupesMessageHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class CheckBookingDuplicatesProcessor
extends BaseProcessor {
    private static final Set<ProductStatus> CHECKED_STATUSES = EnumSet.of(ProductStatus.BOOKING, ProductStatus.INTENTION);

    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef;
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection selectedReservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        Collection notAcceptedReservations = (Collection)ctx.getObject((Enum)IBusAuthorizationContextKeys.PRODUCT_DUPLICATES_MESSAGE_NOT_ACCEPTED_RESERVATIONS);
        Reservation approvalReservation = (Reservation)ctx.getObject((Enum)IBusApprovalContextKeys.APPROVAL_RESERVATION);
        boolean isAutoTicketingTask = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusAuthorizationContextKeys.IS_AUTO_TICKETING_TASK)));
        DuplicatesCheckResult result = DuplicatesCheckResult.WARNING;
        ArrayList<BaseDuplicatesCheckParameters> duplicatesCheckParameters = new ArrayList<BaseDuplicatesCheckParameters>();
        if (!isAutoTicketingTask) {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            siteRef = salesContext.getSite();
        } else {
            siteRef = ((BookingFile)bookingCtr.getEntity()).getSite();
        }
        SMBookingControlSettings bookingControlSettings = CommonHelper.getBookingControlSettings((EntityReference<SMSite>)siteRef);
        if (bookingControlSettings != null) {
            duplicatesCheckParameters = new ArrayList(bookingControlSettings.getDuplicatesCheckParameters());
        }
        BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
        Collection reservations = (Collection)MiscUtil.guarded((Object)notAcceptedReservations, (Object)selectedReservations);
        List<String> ignoreProductUids = this.collectProductUids(approvalReservation);
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>();
        HashMap<Traveller, Set<EntityReference<BookingFile>>> dupeBookingFilesMap = new HashMap<Traveller, Set<EntityReference<BookingFile>>>();
        for (Reservation rs : MidofficeHelper.getReservations((BookingFile)bookingFile, (Collection)reservations)) {
            if (rs == null) continue;
            for (BaseProduct bp : rs.getProducts()) {
                Set<EntityReference<BookingFile>> dupes;
                Product product;
                ProductStatus status = GeneralProductHelper.getHandler((BaseProduct)bp).getStatus(bp);
                if (bp == null || !CHECKED_STATUSES.contains(status)) continue;
                if (bp instanceof Product) {
                    product = (Product)bp;
                    List<AviaDuplicatesCheckParameters> aviaParameters = DupesMessageHelper.getAviaDuplicatesCheckParameters(product, duplicatesCheckParameters);
                    for (AviaDuplicatesCheckParameters parameters : aviaParameters) {
                        Set<EntityReference<BookingFile>> dupes2 = CheckBookingDuplicatesProcessor.getDupeBookings(product, ignoreProductUids, new HashSet<ProductStatus>(parameters.getCheckedStatuses()));
                        if (dupes2.isEmpty() || dupes2.size() <= MiscUtil.guarded((Integer)parameters.getAllowedDupesNumber())) continue;
                        products.add(bp);
                        dupeBookingFilesMap.put(product.getTraveller(), dupes2);
                        if (parameters.getResult() != DuplicatesCheckResult.ERROR) continue;
                        result = DuplicatesCheckResult.ERROR;
                    }
                    continue;
                }
                if (bp instanceof RailwayProduct) {
                    product = (RailwayProduct)bp;
                    List<BaseDuplicatesCheckParameters> railwayParameters = DupesMessageHelper.getBaseDuplicatesCheckParameters(duplicatesCheckParameters, ProductType.RAILWAY_PRODUCT);
                    for (Traveller traveller : product.getPassengers()) {
                        for (BaseDuplicatesCheckParameters parameters : railwayParameters) {
                            dupes = CheckBookingDuplicatesProcessor.getDupeBookings((RailwayProduct)product, traveller, ignoreProductUids, new HashSet<ProductStatus>(parameters.getCheckedStatuses()));
                            if (CollectionUtil.isEmpty(dupes) || dupes.size() <= MiscUtil.guarded((Integer)parameters.getAllowedDupesNumber())) continue;
                            dupeBookingFilesMap.put(traveller, dupes);
                            products.add(bp);
                            if (parameters.getResult() != DuplicatesCheckResult.ERROR) continue;
                            result = DuplicatesCheckResult.ERROR;
                        }
                    }
                    continue;
                }
                if (bp instanceof Transfer) {
                    product = (Transfer)bp;
                    List<BaseDuplicatesCheckParameters> transferParameters = DupesMessageHelper.getBaseDuplicatesCheckParameters(duplicatesCheckParameters, ProductType.TRANSFER);
                    for (Traveller traveller : product.getTravellers()) {
                        for (BaseDuplicatesCheckParameters parameters : transferParameters) {
                            dupes = CheckBookingDuplicatesProcessor.getDupeBookings((Transfer)product, traveller, ignoreProductUids, new HashSet<ProductStatus>(parameters.getCheckedStatuses()));
                            if (CollectionUtil.isEmpty(dupes) || dupes.size() <= MiscUtil.guarded((Integer)parameters.getAllowedDupesNumber())) continue;
                            dupeBookingFilesMap.put(traveller, dupes);
                            products.add(bp);
                            if (parameters.getResult() != DuplicatesCheckResult.ERROR) continue;
                            result = DuplicatesCheckResult.ERROR;
                        }
                    }
                    continue;
                }
                if (!(bp instanceof HotelProduct)) continue;
                product = (HotelProduct)bp;
                List<BaseDuplicatesCheckParameters> hotelParameters = DupesMessageHelper.getBaseDuplicatesCheckParameters(duplicatesCheckParameters, ProductType.HOTEL_RESERVATION);
                for (Traveller traveller : product.getTravellers()) {
                    for (BaseDuplicatesCheckParameters parameters : hotelParameters) {
                        dupes = CheckBookingDuplicatesProcessor.getDupeBookings((HotelProduct)product, traveller, ignoreProductUids, new HashSet<ProductStatus>(parameters.getCheckedStatuses()));
                        if (CollectionUtil.isEmpty(dupes) || dupes.size() <= MiscUtil.guarded((Integer)parameters.getAllowedDupesNumber())) continue;
                        dupeBookingFilesMap.put(traveller, dupes);
                        products.add(bp);
                        if (parameters.getResult() != DuplicatesCheckResult.ERROR) continue;
                        result = DuplicatesCheckResult.ERROR;
                    }
                }
            }
        }
        if (dupeBookingFilesMap.isEmpty()) {
            return;
        }
        if (isAutoTicketingTask) {
            String mesText = DupesMessageHelper.getCommonDupesMessage(dupeBookingFilesMap, null);
            throw new DuplicatesExistsException(mesText, result);
        }
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        salesContext.setClient(bookingFile.getCustomerProfile());
        SMSite site = (SMSite)EntityStorage.get().resolve(salesContext.getSite()).getEntity();
        StringBuilder message = new StringBuilder();
        message.append(DupesMessageHelper.getCommonDupesMessage(dupeBookingFilesMap, site));
        RuleSet ruleSet = SalesContextHandler.get().getRules(salesContext);
        HashSet<String> signatures = new HashSet<String>();
        for (BaseProduct product : products) {
            String template2 = DupesMessageHelper.getSignature(ruleSet, salesContext, product);
            if (!TextUtil.nonBlank((String)template2)) continue;
            signatures.add(template2);
        }
        signatures.forEach(template -> message.append("<br>").append((String)template));
        throw new DuplicatesExistsException(message.toString(), result);
    }

    private List<String> collectProductUids(Reservation reservation) {
        if (reservation == null) {
            return Collections.emptyList();
        }
        return reservation.getProducts().stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private static Set<EntityReference<BookingFile>> getDupeBookings(Transfer product, Traveller traveller, List<String> ignoreProductUids, Set<ProductStatus> statuses) {
        Date startDate = product.getStartDate();
        SearchQuery searchQuery = new SearchQuery();
        List searchCriterions = searchQuery.getCriteria().getCriterions();
        searchCriterions.add(SearchQueryHelper.buildOrEqEnumCriterion((String)TransferIndex.Property.status.name(), statuses));
        searchCriterions.add(SearchCriterion.ge((String)TransferIndex.Property.startDate.name(), (Object)MiscUtil.clearTime((Date)startDate)));
        searchCriterions.add(SearchCriterion.le((String)TransferIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)startDate)));
        SearchResult searchResult = EntityStorage.get().search(TransferIndex.class, searchQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        List data = searchResult.getData();
        if (CollectionUtil.isNotEmpty((Collection)data)) {
            HashSet<EntityReference<BookingFile>> dupeBookingFiles = new HashSet<EntityReference<BookingFile>>();
            data.stream().filter(index -> !MiscUtil.equals((Object)index.getNavigationKey(), (Object)product.getUid())).filter(index -> !ignoreProductUids.contains(index.getNavigationKey())).forEach(index -> {
                BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)((BookingFile)EntityStorage.get().resolve(index.getSource()).getEntity()), (String)index.getNavigationKey());
                Transfer findProduct = (Transfer)baseProduct;
                if (((Traveller)findProduct.getTravellers().get(0)).getName().equals(traveller.getName())) {
                    dupeBookingFiles.add(index.getSource());
                }
            });
            return dupeBookingFiles;
        }
        return Collections.emptySet();
    }

    private static Set<EntityReference<BookingFile>> getDupeBookings(RailwayProduct product, Traveller traveller, List<String> ignoreProductUids, Set<ProductStatus> statuses) throws Exception {
        if (traveller.getPassport() == null) {
            return Collections.emptySet();
        }
        SearchResult searchResult = EntityStorage.get().search(RailwayProductIndex.class, RailwayProductDupesHelper.createSearchQuery((RailwayProduct)product, (Traveller)traveller, (SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrEqEnumCriterion((String)RailwayProductIndex.Property.status.name(), statuses)}), (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        if (CollectionUtil.isEmpty((Collection)searchResult.getData())) {
            return Collections.emptySet();
        }
        HashSet<EntityReference<BookingFile>> dupeBookingFiles = new HashSet<EntityReference<BookingFile>>();
        for (RailwayProductIndex index : searchResult.getData()) {
            RailwayProduct findProduct;
            boolean isPassportDupe;
            BaseProduct baseProduct;
            if (MiscUtil.equals((Object)index.getNavigationKey(), (Object)product.getUid()) || ignoreProductUids.contains(index.getNavigationKey()) || !((baseProduct = BookingHelper.findProduct((BookingFile)((BookingFile)EntityStorage.get().resolve(index.getSource()).getEntity()), (String)index.getNavigationKey())) instanceof RailwayProduct) || !(isPassportDupe = (findProduct = (RailwayProduct)baseProduct).getPassengers().stream().anyMatch(findTraveller -> DupesHelper.isPassportDupe((Passport)traveller.getPassport(), (Passport)findTraveller.getPassport())))) continue;
            dupeBookingFiles.add((EntityReference<BookingFile>)index.getSource());
        }
        return dupeBookingFiles;
    }

    private static Set<EntityReference<BookingFile>> getDupeBookings(HotelProduct product, Traveller traveller, List<String> ignoreProductUids, Set<ProductStatus> statuses) {
        Room room = HotelsReservationHelper.getFirstRoom((HotelProduct)product);
        List<MainHotelProductGuestIndex> data = DupesMessageHelper.getMainHotelProductGuestIndices(traveller.getPassport().getFirstName(), traveller.getPassport().getLastName(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), room.getCheckInDate(), room.getCheckOutDate(), (DictionaryReference<GeoLocation>)product.getHotelLocation(), statuses);
        if (CollectionUtil.isEmpty(data)) {
            return Collections.emptySet();
        }
        return data.stream().filter(index -> !MiscUtil.equals((Object)index.getNavigationKey(), (Object)product.getUid())).filter(index -> !ignoreProductUids.contains(index.getNavigationKey())).map(MainHotelProductGuestIndex::getSource).collect(Collectors.toSet());
    }

    private static Set<EntityReference<BookingFile>> getDupeBookings(Product product, List<String> ignoreProductUids, Set<ProductStatus> checkedStatuses) {
        HashSet<EntityReference<BookingFile>> dupeBookingFiles = new HashSet<EntityReference<BookingFile>>();
        for (ProductIndex productIndex : EntityStorage.get().search(ProductIndex.class, DupesHelper.createSearchQuery((Product)product, checkedStatuses, (SearchCriterion[])new SearchCriterion[0])).getData()) {
            BaseProduct baseProduct;
            Product findProduct;
            if (MiscUtil.equals((Object)productIndex.getNavigationKey(), (Object)product.getUid()) || ignoreProductUids.contains(productIndex.getNavigationKey()) || !DupesHelper.isProductsDupe((Product)product, (Product)(findProduct = (Product)(baseProduct = BookingHelper.findProduct((BookingFile)((BookingFile)EntityStorage.get().resolve(productIndex.getSource()).getEntity()), (String)productIndex.getNavigationKey()))))) continue;
            dupeBookingFiles.add((EntityReference<BookingFile>)productIndex.getSource());
        }
        return dupeBookingFiles;
    }
}

