/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.b2b.BookingFormSettingsToken;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.AcceptSearchDuplicatesMessageIdSupplier;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.BookingFormSettingsTokenSupplier;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import org.apache.commons.lang.BooleanUtils;

public class CheckSearchDuplicateMessageProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isTrue((Boolean)isAutoTicketing)) {
            return;
        }
        Object restParameters = ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        this.checkSearchDuplicatesMessage(ctx, (AcceptSearchDuplicatesMessageIdSupplier)((BookingFormSettingsTokenSupplier)((AcceptSearchDuplicatesMessageIdSupplier)restParameters)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <P extends AcceptSearchDuplicatesMessageIdSupplier & BookingFormSettingsTokenSupplier> void checkSearchDuplicatesMessage(MessageContext ctx, P restParameters) {
        if (TextUtil.isBlank((String)((BookingFormSettingsTokenSupplier)restParameters).getBookingFormSettingsToken())) {
            throw Xeption.forDeveloper((String)"bookingFormSettingsToken is empty", (Object[])new Object[0]);
        }
        BookingFormSettingsToken bookingFormSettingsToken = B2BRestHelper.decodeToken(BookingFormSettingsToken.class, ((BookingFormSettingsTokenSupplier)restParameters).getBookingFormSettingsToken());
        AckMessage searchDuplicatesAckMessage = bookingFormSettingsToken.getSearchDuplicatesMessage();
        if (searchDuplicatesAckMessage != null) {
            if (!MiscUtil.equals((Object)searchDuplicatesAckMessage.getId(), (Object)restParameters.getAcceptSearchDuplicatesMessageId())) throw Xeption.forDeveloper((String)searchDuplicatesAckMessage.getText(), (Object[])new Object[0]);
            ctx.addMessage(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.SEARCH_DUPES_EXISTS), (String)searchDuplicatesAckMessage.getText(), (Object[])new Object[0]));
            return;
        } else {
            if (!TextUtil.nonBlank((String)restParameters.getAcceptSearchDuplicatesMessageId())) return;
            IncidentsLog.reportStackTrace((String)("SearchDuplicatesMessage is accepted with id " + restParameters.getAcceptSearchDuplicatesMessageId() + " but not exists"));
        }
    }
}

