/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates;

import com.gridnine.xtrip.common.ibecorp.rules.SiteNotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.SiteNotificationsPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductGuestIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.duplicates.DupesHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.AviaDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.DuplicatesCheckResult;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DupesMessageHelper {
    public static String getDupeLink(String path, String uid, String number) {
        if (TextUtil.isBlank((String)path)) {
            return number;
        }
        return String.format("<a href=%s>\u2116%s</a>", path + uid, number);
    }

    public static String getDupeLink(String path, EntityReference<BookingFile> bookingFile) {
        return DupesMessageHelper.getDupeLink(path, bookingFile.getUid(), bookingFile.getCaption());
    }

    public static String getPath(SMSite site) {
        StringBuilder linkBuilder = new StringBuilder();
        String schema = site.isHttp() ? "http" : "https";
        linkBuilder.append(schema).append("://");
        linkBuilder.append(site.getDomain());
        linkBuilder.append("/");
        linkBuilder.append("#cabinet/order/");
        return linkBuilder.toString();
    }

    public static String getSignature(RuleSet ruleSet, SalesContext salesCtx, TravelSubject travelSubject, EntityReference<Organization> supplier) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyDate(new Date());
        proxy.setProxyType(Targets.DUPES_NOTIFICATIONS.getId());
        SiteNotificationsPropertySet propertySet = new SiteNotificationsPropertySet(salesCtx, travelSubject, supplier);
        SiteNotificationsActionSet actionSet = new SiteNotificationsActionSet();
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
        return SiteConverterHelper.getLocalizedText(actionSet.getTemplate());
    }

    public static String getSignature(RuleSet ruleSet, SalesContext salesCtx, BaseProduct product) throws Exception {
        TravelSubject travelSubject = GeneralProductHelper.getHandler((BaseProduct)product).getDefaultTravelSubject();
        EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
        return DupesMessageHelper.getSignature(ruleSet, salesCtx, travelSubject, (EntityReference<Organization>)supplier);
    }

    public static String getDupesToTravellerMessage(Traveller traveller, Set<EntityReference<BookingFile>> dupes, String linkPath) {
        return L10nResourcesManager.getStr((String)"DUPES_BOOKING_MESSAGE", (Object[])new Object[]{TextUtil.buildFullName((PersonalName)traveller.getPassport(), (boolean)true), dupes.stream().sorted(Comparator.comparing(EntityReference::getCaption)).map(booking -> DupesMessageHelper.getDupeLink(linkPath, (EntityReference<BookingFile>)booking)).collect(Collectors.joining(", "))});
    }

    public static String getCommonDupesMessage(Map<Traveller, Set<EntityReference<BookingFile>>> dupesMap, SMSite site) {
        String linkPath = site == null ? null : DupesMessageHelper.getPath(site);
        ArrayList<String> dupesBookingMessage = new ArrayList<String>();
        for (Traveller traveller : dupesMap.keySet()) {
            dupesBookingMessage.add(DupesMessageHelper.getDupesToTravellerMessage(traveller, dupesMap.get(traveller), linkPath));
        }
        return L10nResourcesManager.getStr((String)"DUPES_MESSAGE", (Object[])new Object[]{String.join((CharSequence)"; ", dupesBookingMessage)});
    }

    public static List<MainHotelProductGuestIndex> getMainHotelProductGuestIndices(String firstName, String lastName, EntityReference<Organization> clientRef, Date checkIn, Date checkOut, DictionaryReference<GeoLocation> cityRef, Set<ProductStatus> statuses) {
        SearchCriterion statusCriterion = SearchCriterion.not((SearchCriterion)SearchCriterion.in((String)MainHotelProductGuestIndex.Property.reservationStatus.name(), (Object[])new Object[]{ReservationStatus.CANCELED, ReservationStatus.REJECT, ReservationStatus.REFUND, ReservationStatus.PROPOSAL}));
        SearchQuery query = DupesHelper.createSearchQuery((String)firstName, (String)lastName, clientRef, (Date)checkIn, (Date)checkOut, cityRef, (SearchCriterion[])new SearchCriterion[]{statusCriterion});
        return EntityStorage.get().search(MainHotelProductGuestIndex.class, query).getData();
    }

    public static List<BaseDuplicatesCheckParameters> getBaseDuplicatesCheckParameters(List<BaseDuplicatesCheckParameters> duplicatesCheckParameters, ProductType productType) {
        List<BaseDuplicatesCheckParameters> parameters = duplicatesCheckParameters.stream().filter(p -> p.getProductType() == productType).collect(Collectors.toList());
        if (parameters.isEmpty()) {
            BaseDuplicatesCheckParameters defaultParams = new BaseDuplicatesCheckParameters();
            DupesMessageHelper.fillDefaultDuplicatesCheckParameters(defaultParams, productType);
            parameters.add(defaultParams);
        }
        return parameters;
    }

    public static List<AviaDuplicatesCheckParameters> getAviaDuplicatesCheckParameters(Product product, List<BaseDuplicatesCheckParameters> duplicatesCheckParameters) {
        List aviaParameters = duplicatesCheckParameters.stream().filter(p -> p.getProductType() == ProductType.AIR_TICKET).map(p -> (AviaDuplicatesCheckParameters)p).collect(Collectors.toList());
        List<Object> parameters = aviaParameters.stream().filter(p -> MiscUtil.equals((Object)product.getCarrier(), (Object)p.getAirline(), (boolean)false)).collect(Collectors.toList());
        if (parameters.isEmpty()) {
            parameters = aviaParameters.stream().filter(p -> p.getAirline() == null).collect(Collectors.toList());
        }
        if (parameters.isEmpty()) {
            AviaDuplicatesCheckParameters defaultParams = new AviaDuplicatesCheckParameters();
            DupesMessageHelper.fillDefaultDuplicatesCheckParameters((BaseDuplicatesCheckParameters)defaultParams, ProductType.AIR_TICKET);
            parameters.add(defaultParams);
        }
        return parameters;
    }

    public static void fillDefaultDuplicatesCheckParameters(BaseDuplicatesCheckParameters parameters, ProductType productType) {
        parameters.setProductType(productType);
        parameters.setAllowedDupesNumber(Integer.valueOf(0));
        parameters.setResult(DuplicatesCheckResult.WARNING);
        parameters.getCheckedStatuses().addAll(Arrays.asList(ProductStatus.SELL, ProductStatus.BOOKING, ProductStatus.REJECT));
    }
}

