/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.BooleanUtils;

public class IsProductDuplicatesMessageAccepted
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        String acceptProductDuplicatesMessageId = (String)ctx.getObject((Enum)IBusAuthorizationContextKeys.ACCEPT_PRODUCT_DUPLICATES_MESSAGE_ID);
        AckMessage productDuplicatesMessage = (AckMessage)ctx.getObject((Enum)IBusAuthorizationContextKeys.PRODUCT_DUPLICATES_MESSAGE);
        boolean isAutoTicketingTask = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusAuthorizationContextKeys.IS_AUTO_TICKETING_TASK)));
        if (isAutoTicketingTask) {
            return Boolean.toString(true);
        }
        boolean isProductDuplicatesMessageAccepted = this.isProductDuplicatesMessageAccepted(acceptProductDuplicatesMessageId, productDuplicatesMessage);
        if (isProductDuplicatesMessageAccepted) {
            ctx.addMessage(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.PRODUCT_DUPES_EXISTS), (String)productDuplicatesMessage.getText(), (Object[])new Object[0]));
        }
        return Boolean.toString(isProductDuplicatesMessageAccepted);
    }

    private boolean isProductDuplicatesMessageAccepted(String acceptProductDuplicatesMessageId, AckMessage productDuplicatesMessage) {
        if (productDuplicatesMessage == null) {
            if (TextUtil.nonBlank((String)acceptProductDuplicatesMessageId)) {
                IncidentsLog.reportStackTrace((String)("ProductDuplicatesMessage is accepted with id " + acceptProductDuplicatesMessageId + " but not exists"));
            }
            return false;
        }
        if (MiscUtil.equals((Object)productDuplicatesMessage.getId(), (Object)acceptProductDuplicatesMessageId)) {
            return true;
        }
        throw Xeption.forDeveloper((String)productDuplicatesMessage.getText(), (Object[])new Object[0]);
    }
}

