/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.geocoder;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.sm.GeocoderApiTokenType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.transfers.IWayGeocodeParameters;
import com.gridnine.xtrip.server.geocoder.ibus.IBusGeocoderContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.geocoder.RestGeocodeParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Objects;

public class PrepareGeocodeParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        RestGeocodeParameters params = (RestGeocodeParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMGeneralSettings generalSettings = Objects.requireNonNull(CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef));
        if (generalSettings.getGeocoderApiTokenType() != GeocoderApiTokenType.IWAY) {
            throw Xeption.forDeveloper((String)"GeocoderApiTokenType {0} isn't supported", (Object[])new Object[]{generalSettings.getGeocoderApiTokenType()});
        }
        IWayGeocodeParameters result = new IWayGeocodeParameters();
        result.setGeocode(params.getGeocode());
        result.setGdsAccount(generalSettings.getGeocoderIwayGdsAccount());
        ctx.putObject((Enum)IBusGeocoderContextKeys.GEOCODE_PARAMETERS, (Object)result);
    }
}

