/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.CancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.CancellationChargeHolder;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.hotels2.model.DocumentCategory;
import com.gridnine.xtrip.common.hotels2.model.DocumentReference;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOptionAvailabilityType;
import com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy;
import com.gridnine.xtrip.common.hotels2.model.MealOption;
import com.gridnine.xtrip.common.hotels2.model.NonCancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.RoomInfo;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.TaxInfo;
import com.gridnine.xtrip.common.model.booking.xtriphotels.XtripHotelProductHelper;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsPayee;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsStayType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectHolder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.CancellationPolicyHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelCancellationRulesHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.TokenRoom;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.AdditionalServices;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Address;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EarlierCheckInOption;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EssentialInfoDataType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Facility;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Guarantee;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelCard;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelCityInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOfferOptions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Image;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.LaterCheckOutOption;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.MealPlan;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Phone;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.PolicyDescription;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Remark;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.HotelPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class HotelsConverterHelper {
    private static final int BOOKING_AVAILABLE_BEFORE_TIME_LIMIT_HOURS = 48;

    public static RoomInfo convertToRoomInfo(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room room) {
        RoomInfo result = new RoomInfo();
        if (!room.getTravellers().isEmpty()) {
            result.setStandardNumberOfGuests(room.getTravellers().size());
            room.getTravellers().stream().map(personRef -> EntityStorage.get().resolve(personRef)).map(HotelsConverterHelper::convertToTraveller).forEach(tr -> result.getTravellers().add(tr));
            result.setStandardNumberOfGuests(room.getTravellers().size());
            return result;
        }
        int limit = (Integer)room.getTravellersInfo().get(DictHelper.getAdultPassengerType());
        for (int i = 0; i < limit; ++i) {
            result.getTravellers().add(new Traveller());
        }
        Integer numberOfChildren = (Integer)room.getTravellersInfo().get(DictHelper.getChildPassengerType());
        int n = limit = numberOfChildren != null ? numberOfChildren : 0;
        if (limit > 0 && room.getChildrenAge().isEmpty()) {
            throw Xeption.forDeveloper((String)"childrenAge is empty", (Object[])new Object[0]);
        }
        for (int i = 0; i < limit; ++i) {
            Traveller child = new Traveller();
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -((Integer)room.getChildrenAge().get(i)).intValue());
            child.setBirthday(MiscUtil.clearTime((Date)calendar.getTime()));
            result.getTravellers().add(child);
        }
        result.setStandardNumberOfGuests(room.getTravellers().size());
        return result;
    }

    public static com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room createRestRoom(HotelProduct product) {
        com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room restRoom = new com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room();
        restRoom.getTravellers().addAll(product.getTravellers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList()));
        restRoom.getTravellersInfo().putAll(product.getTravellersPassengerTypes().stream().map(PassengerTypeReference::getPassengerType).collect(Collectors.groupingBy(passType -> passType, Collectors.summingInt(a -> 1))));
        restRoom.getChildrenAge().addAll(product.getTravellers().stream().filter(traveller -> traveller.getPassport() != null).map(traveller -> traveller.getPassport().getBirthday()).filter(HotelsReservationHelper::isChild).map(ProfileHelper::getFullAge).collect(Collectors.toList()));
        return restRoom;
    }

    private static Traveller convertToTraveller(EntityContainer<Person> personCtr) {
        Traveller result = new Traveller();
        result.setBirthday(MiscUtil.clearTime((Date)ProfileHelper.getPersonBirthday((Person)((Person)personCtr.getEntity()))));
        result.setPassenger(personCtr.toReference());
        return result;
    }

    public static TokenRoom convertToTokenRoom(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room room) {
        TokenRoom result = new TokenRoom();
        result.getSelectedTravellers().addAll(room.getTravellers());
        return result;
    }

    public static HotelCard convertHotelCardWithOffers(com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCard, PriceComponentsParameters priceComponentsParameters, boolean isAgency, EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons, EntityReference<BookingFile> bookingFileRef) {
        return HotelsConverterHelper.convertHotelCardWithOffers(hotelCard, priceComponentsParameters, false, isAgency, clientRef, persons, Collections.emptyList(), bookingFileRef);
    }

    public static HotelCard convertHotelCardWithOffers(com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCard, PriceComponentsParameters priceComponentsParameters, boolean ignoreHide, boolean isAgency, EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons, List<TokenRoom> tokenRooms, EntityReference<BookingFile> bookingFileRef) {
        HotelOffer offer = (HotelOffer)hotelCard.getHotelOffers().get(0);
        LocalDate checkIn = offer.getStayPolicy().getCheckInDate();
        LocalDate checkOut = offer.getStayPolicy().getCheckOutDate();
        return HotelsConverterHelper.convertHotelCard(hotelCard, priceComponentsParameters, false, ignoreHide, isAgency, clientRef, persons, tokenRooms, bookingFileRef, checkIn, checkOut);
    }

    public static HotelCard convertHotelCard(com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCard, PriceComponentsParameters priceComponentsParameters, Boolean forFilter, boolean isAgency, EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons, List<TokenRoom> tokenRooms, EntityReference<BookingFile> bookingFileRef, LocalDate checkIn, LocalDate checkOut) {
        return HotelsConverterHelper.convertHotelCard(hotelCard, priceComponentsParameters, forFilter, false, isAgency, clientRef, persons, tokenRooms, bookingFileRef, checkIn, checkOut);
    }

    private static HotelCard convertHotelCard(com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCard, PriceComponentsParameters priceComponentsParameters, Boolean forFilter, boolean ignoreHide, boolean isAgency, EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons, List<TokenRoom> tokenRooms, EntityReference<BookingFile> bookingFileRef, LocalDate checkIn, LocalDate checkOut) {
        HotelCard result = new HotelCard();
        result.setNumber(hotelCard.getNumber());
        result.setName(hotelCard.getName());
        result.setHotelStars(hotelCard.getHotelStars());
        result.setDescription(hotelCard.getDescription());
        result.setNumberOfNights((int)ChronoUnit.DAYS.between(checkIn, checkOut));
        result.setHotelType((HotelType)EnumUtil.recodeSafe((Enum)hotelCard.getHotelType(), HotelType.class));
        HotelsStayPolicy stayPolicy = hotelCard.getHotelOffers().stream().map(HotelOffer::getStayPolicy).filter(Objects::nonNull).filter(sp -> sp.getCheckInTime() != null && sp.getCheckOutTime() != null).findFirst().orElse(null);
        if (stayPolicy != null) {
            result.setCheckInDateTime(stayPolicy.getCheckInDate() != null ? stayPolicy.getCheckInDate().atTime(stayPolicy.getCheckInTime()) : checkIn.atTime(stayPolicy.getCheckInTime()));
            result.setCheckOutDateTime(stayPolicy.getCheckOutDate() != null ? stayPolicy.getCheckOutDate().atTime(stayPolicy.getCheckOutTime()) : checkOut.atTime(stayPolicy.getCheckOutTime()));
        }
        result.setAddress(HotelsConverterHelper.convertAddress(hotelCard.getAddress(), hotelCard.getLongitude(), hotelCard.getLatitude()));
        result.getPhones().addAll(hotelCard.getContacts().stream().map(HotelsConverterHelper::convertToPhone).filter(Objects::nonNull).collect(Collectors.toList()));
        result.getFacilities().addAll(hotelCard.getFacilities().stream().map(HotelsConverterHelper::convertFacility).collect(Collectors.toList()));
        result.getImages().addAll(hotelCard.getDocuments().stream().filter(doc -> doc.getCategory() == DocumentCategory.IMAGE).map(HotelsConverterHelper::convertToImage).collect(Collectors.toList()));
        com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCardWithoutOffers = BooleanUtils.isNotTrue((Boolean)forFilter) ? HotelsConverterHelper.copyHotelCardWithoutOffers(hotelCard) : hotelCard;
        for (HotelOffer offer : hotelCard.getHotelOffers()) {
            if (!ignoreHide && CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)offer) || forFilter == null) continue;
            try {
                Price price = HotelPriceComponents.builder(offer, priceComponentsParameters).build().createPrice();
                com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer restOffer = HotelsConverterHelper.convertHotelOffer(hotelCardWithoutOffers, offer, isAgency, price, clientRef, persons, tokenRooms, bookingFileRef, forFilter, checkIn, checkOut);
                result.getHotelOffers().add(restOffer);
            }
            catch (Throwable ex) {
                IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)(offer.getGdsAccount() != null ? offer.getGdsAccount().toString() : "")), IncidentsHelper.getContextStackTraceElement((String)"Vendor", (String)offer.getVendor()), IncidentsHelper.getContextStackTraceElement((String)"HotelCardNumber", (String)offer.getHotelCardNumber()), IncidentsHelper.getContextStackTraceElement((String)"RoomName", (String)offer.getRoomName())});
                IncidentsLog.reportException((String)"convert offer in convertHotelCard failed", (Throwable)ex);
            }
        }
        for (com.gridnine.xtrip.common.hotels2.model.PolicyDescription pd : hotelCard.getPolicyDescriptions()) {
            PolicyDescription item = new PolicyDescription();
            item.setTitle(pd.getTitle());
            item.setDescription(pd.getDescription());
            result.getPolicyDescriptions().add(item);
        }
        return result;
    }

    private static Address convertAddress(com.gridnine.xtrip.common.model.profile.Address address, Double hotelLongitude, Double hotelLatitude) {
        Address result = new Address();
        result.setAddress(address.getAddress().toString());
        HotelCityInfo cityInfo = new HotelCityInfo();
        cityInfo.setCity(address.getCity());
        GeoLocation city = (GeoLocation)DictHelper.resolve((DictionaryReference)address.getCity());
        if (city != null) {
            cityInfo.setLongitude(Double.valueOf(city.getLongitude()));
            cityInfo.setLatitude(Double.valueOf(city.getLatitude()));
        }
        result.setCityInfo(cityInfo);
        result.setCountry(address.getCountry());
        result.setLatitude(hotelLatitude);
        result.setLongitude(hotelLongitude);
        result.setZipCode(address.getZip());
        return result;
    }

    private static Phone convertToPhone(Communication communication) {
        if (communication.getType() != CommunicationType.WORK_PHONE || communication.getType() != CommunicationType.MOBILE) {
            return null;
        }
        Phone result = new Phone();
        result.setType(communication.getType());
        result.setValue(communication.getSense());
        return result;
    }

    private static Facility convertFacility(com.gridnine.xtrip.common.hotels2.model.Facility facility) {
        Facility result = new Facility();
        result.setCode(facility.getCode());
        result.setCaption(facility.getCaption());
        result.setCategory(facility.getCategory());
        return result;
    }

    private static Image convertToImage(DocumentReference reference) {
        Image result = new Image();
        result.setUid(reference.getGdsId());
        result.setCaption(reference.getTitle());
        return result;
    }

    public static com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer convertHotelOffer(com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCardWithoutOffers, HotelOffer offer, boolean isAgency, Price price, EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons, List<TokenRoom> tokenRooms, EntityReference<BookingFile> bookingFileRef, boolean forFilter, LocalDate checkIn, LocalDate checkOut) throws Exception {
        com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer result = new com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer();
        result.setId(offer.getId());
        result.setOnline(offer.isFreeForSale());
        result.setProvider(offer.getProvider());
        result.setProviderHotelCode(offer.getProviderHotelCode());
        result.setSubProvider(offer.getVendor());
        result.setMeal(HotelsConverterHelper.convertMealPlan(offer.getMealIncluded()));
        result.setPrice(price);
        result.setTotalMaxPrice(offer.getTotalMaxPrice());
        int totalNights = HotelProductHelper.calculateNights((Date)DateUtils.toJavaDate((LocalDate)checkIn), (Date)DateUtils.toJavaDate((LocalDate)checkOut));
        if (totalNights != 0) {
            Money dailyAveragePrice = CommonConverterHelper.convertMoney2Rest(price.getTotal().getAmount().divide(BigDecimal.valueOf(totalNights), RoundingMode.HALF_UP), price.getTotal().getCurrencyCode());
            result.setDailyAveragePrice(dailyAveragePrice);
        }
        CommonConverterHelper.addTravelPolicyInfo(offer.getTravelPolicyImpositionResult(), (HasTravelPolicyCompliance)result);
        boolean paymentInHotel = offer.getAvailability() != null && offer.getAvailability().getPayee() == HotelsPayee.HOTEL;
        result.setPaymentInHotel(paymentInHotel);
        if (!paymentInHotel && offer.getStatusOffer() != ProductStatus.REFUND) {
            boolean canCancelWithoutPenalties;
            Date timeLimit = HotelsConverterHelper.getTimeLimit(offer, MiscUtil.toDate((LocalDate)offer.getStayPolicy().getCheckInDate()));
            Date now = new Date();
            boolean bl = canCancelWithoutPenalties = HotelsConverterHelper.canCancelWithoutPenalties(offer) && (null == timeLimit || timeLimit.after(now));
            if (!canCancelWithoutPenalties) {
                result.setOfferWithPenalty(Boolean.valueOf(true));
            }
        }
        Supplier<HotelOfferOptions> options = () -> {
            HotelOfferOptions o = result.getOptions();
            if (null == o) {
                o = new HotelOfferOptions();
                result.setOptions(o);
            }
            return o;
        };
        offer.getOptions().getMealOptions().stream().filter(o -> o.getAvailability().getType() != null && o.getAvailability().getType() != HotelsServiceOptionAvailabilityType.INCLUDED).map(HotelsConverterHelper::convertMealPlan).filter(Objects::nonNull).forEach(options.get().getMeals()::add);
        for (TaxInfo taxInfo : offer.getTaxInfoList()) {
            com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.TaxInfo item = new com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.TaxInfo();
            item.setName(taxInfo.getName());
            item.setAmount(CommonConverterHelper.convertMoney2Rest(taxInfo.getAmount()));
            item.setIncludedInTariff(taxInfo.isIncludedInTariff());
            result.getTaxInfoList().add(item);
        }
        result.setTripartiteContract(offer.isTripartiteContract());
        result.setClientTariffCode(offer.getClientTariffCode());
        if (forFilter) {
            return result;
        }
        result.setRoomName(offer.getRoomName());
        result.setRoomDescription(offer.getRoomDescription());
        result.setRoomsNumber(offer.getRoomsNumber());
        result.getEssentialInfo().addAll(offer.getEssentialInfo());
        result.getEssentialInfoList().addAll(HotelsConverterHelper.convertEssentialInfoList(offer.getEssentialInfoList(), isAgency));
        if (isAgency) {
            result.setRackRate(CommonConverterHelper.convertMoney2Rest(offer.getRackRate()));
        }
        result.setCommentAllowed(offer.getProvider() == HotelProvider.INTERNAL || offer.isCommentAllowed());
        RestHotelsOfferToken token = new RestHotelsOfferToken();
        token.setOffer(offer);
        token.setHotelCardWithoutOffers(hotelCardWithoutOffers);
        token.setClient(clientRef);
        if (persons != null) {
            token.getPersons().addAll(persons);
        }
        token.getRooms().addAll(tokenRooms);
        token.setBookingFile(bookingFileRef);
        result.setToken(CommonRestHelper.encodeToken((BaseEntity)token));
        if (offer.getStatusOffer() != ProductStatus.REFUND) {
            String cancellationTextNextStep = HotelsConverterHelper.getCancellationTextNextStep(offer.getStatusOffer());
            String cancellationPolicyText = HotelsConverterHelper.getCancellationPolicyText(offer, price, cancellationTextNextStep);
            result.setCancellationPolicyText(cancellationPolicyText);
            result.setCancellable(offer.isCancellable());
            result.setCancellationPolicyNextStep(MiscUtil.equals((Object)cancellationTextNextStep, (Object)cancellationPolicyText));
            result.setFreeCancellationTerm(HotelsConverterHelper.getFreeCancellationTerm(offer));
            result.setCancellationPolicyPricesMayChange(Boolean.valueOf(offer.isCancellationPolicyCostsMayChange()));
        }
        result.getTravellersInfo().putAll(offer.getRoomInfo().getTravellers().stream().map(HotelsReservationHelper::getTravellerPassengerType).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum))));
        HotelsStayPolicy stayPolicy = offer.getStayPolicy();
        LocalDate checkInDate = stayPolicy.getCheckInDate();
        LocalTime checkInTime = stayPolicy.getCheckInTime();
        LocalTime standardCheckInTime = stayPolicy.getStandardCheckInTime();
        LocalDate checkOutDate = stayPolicy.getCheckOutDate();
        LocalTime checkOutTime = stayPolicy.getCheckOutTime();
        LocalTime standardCheckOutTime = stayPolicy.getStandardCheckOutTime();
        result.setStandardCheckIn(HotelsConverterHelper.convertDateTime(checkInDate, standardCheckInTime));
        result.setStandardCheckOut(HotelsConverterHelper.convertDateTime(checkOutDate, standardCheckOutTime));
        result.setCheckIn(HotelsConverterHelper.convertDateTime(checkInDate, checkInTime));
        result.setCheckOut(HotelsConverterHelper.convertDateTime(checkOutDate, checkOutTime));
        if (offer.getStayPolicy().getType() != HotelsStayType.FIXED_HOURS) {
            com.gridnine.xtrip.common.model.system.Money ratePerNight = HotelProductHelper.calculateRawPriceRatePerNight((LocalDate)stayPolicy.getCheckInDate(), (LocalDate)stayPolicy.getCheckOutDate(), (com.gridnine.xtrip.common.model.system.Money)offer.getBasePrice());
            BigDecimal amountDay = ratePerNight != null ? ratePerNight.getValue() : null;
            offer.getOptions().getCheckInOptions().stream().filter(o -> o.getAvailability().getType() != null && o.getAvailability().getType() != HotelsServiceOptionAvailabilityType.INCLUDED && (o.getFrom() == null || null == standardCheckInTime || !o.getFrom().isAfter(standardCheckInTime))).map(o -> {
                EarlierCheckInOption option = new EarlierCheckInOption();
                option.setFrom(o.getFrom());
                option.setTo(o.getTo());
                option.setGuaranteed(BooleanUtil.nullAsFalse((Boolean)o.getAvailability().getGuaranteed()));
                option.setOperation(o.getAvailability().getType());
                option.setPercent(o.getPrice() != null ? HotelsConverterHelper.getPercent(amountDay, o.getPrice().getValue()) : null);
                return option;
            }).forEach(options.get().getEarlierCheckIn()::add);
            offer.getOptions().getCheckOutOptions().stream().filter(o -> o.getAvailability().getType() != null && o.getAvailability().getType() != HotelsServiceOptionAvailabilityType.INCLUDED && (o.getTo() == null || null == standardCheckOutTime || !o.getFrom().isBefore(standardCheckOutTime))).map(o -> {
                LaterCheckOutOption option = new LaterCheckOutOption();
                option.setFrom(o.getFrom());
                option.setTo(o.getTo());
                option.setGuaranteed(BooleanUtil.nullAsFalse((Boolean)o.getAvailability().getGuaranteed()));
                option.setOperation(o.getAvailability().getType());
                option.setPercent(o.getPrice() != null ? HotelsConverterHelper.getPercent(amountDay, o.getPrice().getValue()) : null);
                return option;
            }).forEach(options.get().getLaterCheckOut()::add);
        }
        result.setAdditionalServices(HotelsConverterHelper.buildAdditionalServices(offer));
        offer.getGuarantees().forEach(g -> result.getGuarantees().add(HotelsConverterHelper.convertGuarantee(g)));
        result.getRemarks().addAll(HotelsConverterHelper.convertRemarks(offer.getRemarkList()));
        return result;
    }

    public static AdditionalServices buildAdditionalServices(HotelOffer offer) {
        Optional<AdditionalService> lateCheckOut;
        HotelsStayPolicy stayPolicy = offer.getStayPolicy();
        ObjectHolder resultHolder = new ObjectHolder();
        Supplier<AdditionalServices> additionalServices = () -> {
            AdditionalServices p = (AdditionalServices)resultHolder.getValue();
            if (null == p) {
                p = new AdditionalServices();
                resultHolder.setValue((Object)p);
            }
            return p;
        };
        LocalTime guardedCheckInTime = (LocalTime)MiscUtil.guarded((Object)stayPolicy.getCheckInTime(), (Object)stayPolicy.getStandardCheckInTime());
        LocalTime guardedCheckOutTime = (LocalTime)MiscUtil.guarded((Object)stayPolicy.getCheckOutTime(), (Object)stayPolicy.getStandardCheckOutTime());
        Optional<AdditionalService> earlyCheckIn = offer.getAdditionalServices().stream().filter(service -> service.getType() == AdditionalServiceType.EARLIER_CHECKIN).findFirst();
        if (earlyCheckIn.isPresent()) {
            additionalServices.get().setCheckIn(guardedCheckInTime);
            additionalServices.get().setCheckInInfo(earlyCheckIn.get().getName());
            additionalServices.get().setCheckInAmount(earlyCheckIn.get().getEquivalentAmount());
            HotelsServiceOptionAvailabilityType operation = offer.getOptions().getCheckInOptions().stream().filter(o -> !(o.getAvailability().getType() == HotelsServiceOptionAvailabilityType.INCLUDED || o.getFrom() != null && !o.getFrom().isBefore(guardedCheckInTime) || o.getTo() != null && !o.getTo().isAfter(guardedCheckInTime))).map(o -> o.getAvailability().getType()).findFirst().orElse(null);
            additionalServices.get().setCheckInByRequest(Boolean.valueOf(HotelsServiceOptionAvailabilityType.REQUEST == operation));
        }
        if ((lateCheckOut = offer.getAdditionalServices().stream().filter(service -> service.getType() == AdditionalServiceType.LATER_CHECKOUT).findFirst()).isPresent()) {
            additionalServices.get().setCheckOut(guardedCheckOutTime);
            additionalServices.get().setCheckOutInfo(lateCheckOut.get().getName());
            additionalServices.get().setCheckOutAmount(lateCheckOut.get().getEquivalentAmount());
            HotelsServiceOptionAvailabilityType operation = offer.getOptions().getCheckOutOptions().stream().filter(o -> !(o.getAvailability().getType() == HotelsServiceOptionAvailabilityType.INCLUDED || o.getFrom() != null && !o.getFrom().isBefore(guardedCheckOutTime) || o.getTo() != null && !o.getTo().isAfter(guardedCheckOutTime))).map(o -> o.getAvailability().getType()).findFirst().orElse(null);
            additionalServices.get().setCheckOutByRequest(Boolean.valueOf(HotelsServiceOptionAvailabilityType.REQUEST == operation));
        }
        offer.getAdditionalServices().stream().filter(s -> s.getType() == AdditionalServiceType.MEAL).forEach(meal -> {
            ((AdditionalServices)additionalServices.get()).getMeals().add(HotelsConverterHelper.convertMealPlan(meal));
            ((AdditionalServices)additionalServices.get()).setMealAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{((AdditionalServices)additionalServices.get()).getMealAmount(), meal.getEquivalentAmount()}));
            HotelsServiceOptionAvailabilityType operation = offer.getOptions().getMealOptions().stream().filter(o -> o.getAvailability().getType() != null && o.getAvailability().getType() != HotelsServiceOptionAvailabilityType.INCLUDED && Objects.equals(HotelsConverterHelper.getMealCode(o), meal.getCode())).map(o -> o.getAvailability().getType()).findFirst().orElse(null);
            ((AdditionalServices)additionalServices.get()).setMealByRequest(Boolean.valueOf(HotelsServiceOptionAvailabilityType.REQUEST == operation));
        });
        offer.getAdditionalServices().stream().filter(s -> s.getType().equals((Object)AdditionalServiceType.EARLIER_CHECKIN)).findFirst().ifPresent(earlierCheckIn -> {
            ((AdditionalServices)additionalServices.get()).setCheckIn(guardedCheckInTime);
            ((AdditionalServices)additionalServices.get()).setCheckInAmount(earlierCheckIn.getBaseAmount().getValue());
        });
        offer.getAdditionalServices().stream().filter(s -> s.getType().equals((Object)AdditionalServiceType.LATER_CHECKOUT)).findFirst().ifPresent(laterCheckout -> {
            ((AdditionalServices)additionalServices.get()).setCheckOut(guardedCheckOutTime);
            ((AdditionalServices)additionalServices.get()).setCheckOutAmount(laterCheckout.getBaseAmount().getValue());
        });
        return (AdditionalServices)resultHolder.getValue();
    }

    private static List<Remark> convertRemarks(List<com.gridnine.xtrip.common.hotels2.model.Remark> remarkList) {
        ArrayList<Remark> result = new ArrayList<Remark>();
        for (com.gridnine.xtrip.common.hotels2.model.Remark remark : remarkList) {
            Remark item = new Remark();
            item.setId(remark.getId());
            item.setType(remark.getType());
            item.setDataType(remark.getDataType());
            item.setTitle(remark.getTitle());
            result.add(item);
        }
        return result;
    }

    private static LocalDateTime getFreeCancellationTerm(HotelOffer offer) {
        Date freeCancellationTerm = null;
        if (offer.getCancellationPolicy() instanceof CancellablePolicy) {
            CancellablePolicy cp = (CancellablePolicy)offer.getCancellationPolicy();
            if (cp.getCancellationChargesHolder() == null) {
                return null;
            }
            freeCancellationTerm = cp.getCancellationChargesHolder().getFreeCancellationTerm();
        }
        if (freeCancellationTerm == null) {
            return null;
        }
        if (freeCancellationTerm.before(new Date())) {
            return null;
        }
        return DateUtils.toLocalDateTime((Date)freeCancellationTerm);
    }

    private static List<com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EssentialInfoData> convertEssentialInfoList(List<EssentialInfoData> infoList, boolean isAgency) {
        if (null == infoList) {
            return Collections.emptyList();
        }
        Map<EssentialInfoDataType, Collection> correctedMap = infoList.stream().filter(eid -> isAgency || eid.getType() != com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoDataType.SPECIAL_RATE_INFORMATION).collect(Collectors.toMap(eid -> HotelsConverterHelper.convertEssentialInfoDataTypeFromGds(eid.getType()), EssentialInfoData::getInfoValue, CollectionUtil::union));
        ArrayList<com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EssentialInfoData> result = new ArrayList<com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EssentialInfoData>();
        correctedMap.forEach((type, list) -> {
            com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EssentialInfoData item = new com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.EssentialInfoData();
            item.setType(type);
            item.getInfoValue().addAll(list);
            result.add(item);
        });
        return result;
    }

    private static EssentialInfoDataType convertEssentialInfoDataTypeFromGds(com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoDataType value) {
        if (value == null) {
            return EssentialInfoDataType.ADDITIONAL_INFORMATION;
        }
        switch (value) {
            case ROOM_AMENITIES: {
                return EssentialInfoDataType.ROOM_AMENITIES;
            }
        }
        return EssentialInfoDataType.ADDITIONAL_INFORMATION;
    }

    private static Guarantee convertGuarantee(com.gridnine.xtrip.common.hotels2.model.Guarantee guarantee) {
        Guarantee result = new Guarantee();
        result.setType(guarantee.getType());
        result.getCardTypes().addAll(guarantee.getCardTypes());
        return result;
    }

    private static Integer getPercent(BigDecimal amountDay, BigDecimal price) {
        if (null == amountDay || BigDecimal.ZERO.compareTo(amountDay) == 0 || null == price) {
            return null;
        }
        return price.divide(amountDay, 2, RoundingMode.CEILING).multiply(new BigDecimal("100")).setScale(0, RoundingMode.CEILING).intValue();
    }

    private static MealPlan convertMealPlan(AdditionalService meal) {
        String code = meal.getCode();
        String caption = TextUtil.firstNonBlank((String[])new String[]{meal.getName(), code});
        MealPlan result = new MealPlan();
        result.setUid(code);
        result.setCaption(caption);
        result.setBaseMealCode(null);
        return result;
    }

    private static MealPlan convertMealPlan(com.gridnine.xtrip.common.hotels2.model.MealPlan plan) {
        if (null == plan || StringUtils.isBlank((String)plan.getCode())) {
            return null;
        }
        String code = plan.getCode();
        String caption = TextUtil.firstNonBlank((String[])new String[]{plan.getCaption(), plan.getMealTypeCaption(), code});
        String baseMealCode = plan.getBasemealId();
        MealPlan result = new MealPlan();
        result.setUid(code);
        result.setCaption(caption);
        result.setBaseMealCode(baseMealCode);
        result.setWithoutMeal("\u0411\u0435\u0437 \u043f\u0438\u0442\u0430\u043d\u0438\u044f".equals(plan.getBasemealCaption()));
        return result;
    }

    public static String getMealCode(MealOption plan) {
        return TextUtil.firstNonBlank((String[])new String[]{plan.getProviderCode(), plan.getMealCode(), plan.getBaseMealCode()});
    }

    public static String getMealCaption(MealOption plan) {
        String caption = TextUtil.firstNonBlank((String[])new String[]{plan.getMealCaption(), plan.getProviderCaption()});
        if (caption != null) {
            return caption;
        }
        return HotelsConverterHelper.getMealCode(plan);
    }

    private static MealPlan convertMealPlan(MealOption plan) {
        if (plan == null) {
            return null;
        }
        String code = HotelsConverterHelper.getMealCode(plan);
        if (null == code) {
            return null;
        }
        MealPlan result = new MealPlan();
        result.setUid(code);
        result.setCaption(HotelsConverterHelper.getMealCaption(plan));
        result.setBaseMealCode(plan.getBaseMealCode());
        return result;
    }

    private static String getCancellationPolicyText(HotelOffer offer, Price price, String text) {
        String gdsCurrency = offer.getBasePrice() != null ? offer.getBasePrice().getCurrency() : null;
        String policyText = HotelCancellationRulesHelper.buildCancellationRules((CancellationPolicy)offer.getCancellationPolicy(), (com.gridnine.xtrip.common.model.system.Money)MoneyHelper.buildMoney((BigDecimal)price.getTotal().getAmount(), (String)price.getTotal().getCurrency()), (LocalDate)offer.getStayPolicy().getCheckInDate(), (List)offer.getContractRelations(), (String)gdsCurrency, null);
        return TextUtil.nonBlank((String)policyText) ? policyText : text;
    }

    private static String getCancellationTextNextStep(ProductStatus status) {
        if (status == ProductStatus.REFUND) {
            return null;
        }
        if (status == ProductStatus.SELL) {
            return L10nResourcesManager.getStr((String)"CHECK_WITH_HOTEL_PROVIDER_FOR_PENALTIES", (Locale)LocaleHelper.getCurrentLocale(), (Object[])new Object[0]);
        }
        return L10nResourcesManager.getStr((String)"HOTELS_CANCELATION_PENALTIES_WILL_BE_KNOWN_NEXT_STEP", (Locale)LocaleHelper.getCurrentLocale(), (Object[])new Object[0]);
    }

    public static void prepareContext(MessageContext ctx, RestHotelsOfferToken token) {
        EntityReference clientRef = token.getClient();
        if (clientRef != null) {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            salesContext.setClient(clientRef);
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(clientRef);
            travelPolicyParams.getPersons().addAll(token.getPersons());
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
        if (token.getBookingFile() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(token.getBookingFile());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
    }

    public static Traveller convertTraveller(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller guest, Date arriveDate) {
        Traveller result = CommonConverterHelper.convertTravellerFromRest((RestTraveller)guest, arriveDate);
        if (guest.getUid() != null) {
            result.setPassenger(new EntityReference(guest.getUid(), Person.class, null));
        }
        return result;
    }

    public static void updateTravellersWithCostCodes(HotelOffer offer, Map<Traveller, List<PersonCostCode>> travellersCostCodes, com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.RoomInfo room, EntityReference<Organization> clientRef) {
        Date arriveDate = DateUtils.toJavaDate((LocalDate)offer.getStayPolicy().getCheckOutDate());
        List offerTravellers = offer.getRoomInfo().getTravellers();
        offerTravellers.clear();
        for (com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller guest : room.getTravellers()) {
            Traveller traveller = HotelsConverterHelper.convertTraveller(guest, arriveDate);
            offerTravellers.add(traveller);
            List<PersonCostCode> costCodes = CorporateClientHelper.convertPersonRestCostCodes(guest.getCostCodes(), clientRef, (EntityReference<Person>)traveller.getPassenger());
            travellersCostCodes.put(traveller, costCodes);
        }
    }

    public static List<com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller> convertTravellers2Rest(Reservation reservation) {
        return CommonHelper.collectTravellers(reservation).stream().filter(Objects::nonNull).map(traveller -> HotelsConverterHelper.convertTravellerToRest(traveller, reservation)).collect(Collectors.toList());
    }

    public static com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller convertTravellerToRest(Traveller srcTraveller, Reservation reservation) {
        com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller traveller = new com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller();
        CommonConverterHelper.updateRestTraveller((RestTraveller)traveller, srcTraveller);
        traveller.getCostCodes().addAll(CommonConverterHelper.convertCostCodesToRest(reservation, srcTraveller));
        HotelsConverterHelper.setPassengerType(reservation, srcTraveller, (RestTraveller)traveller);
        return traveller;
    }

    private static void setPassengerType(Reservation reservation, Traveller traveller, RestTraveller restTraveller) {
        BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).map(HotelProduct::getTravellersPassengerTypes).flatMap(Collection::stream).filter(psr -> MiscUtil.equals((Object)psr.getTravellerUid(), (Object)traveller.getUid())).findFirst().ifPresent(typeRef -> restTraveller.setType(typeRef.getPassengerType()));
    }

    private static boolean canCancelWithoutPenalties(HotelOffer offer) {
        return HotelsConverterHelper.canCancelWithoutPenalties(offer.getCancellationPolicy(), MiscUtil.toDate((LocalDate)offer.getStayPolicy().getCheckInDate()));
    }

    public static boolean canCancelWithoutPenalties(HotelProduct product) {
        return HotelsConverterHelper.canCancelWithoutPenalties(CancellationPolicyHelper.buildHotelsCancellationPolicy((HotelProduct)product), ((Room)product.getRooms().get(0)).getCheckInDate());
    }

    private static boolean canCancelWithoutPenalties(CancellationPolicy cancellationPolicy, Date checkIn) {
        CancellablePolicy cancellablePolicy;
        CancellationChargeHolder chargesHolder;
        if (cancellationPolicy instanceof NonCancellablePolicy) {
            return false;
        }
        List cancellationCharges = Collections.emptyList();
        if (cancellationPolicy instanceof CancellablePolicy && (chargesHolder = (cancellablePolicy = (CancellablePolicy)cancellationPolicy).getCancellationChargesHolder()) != null) {
            cancellationCharges = chargesHolder.getCancellationCharges();
        }
        return new Date().before(HotelsConverterHelper.getTimeLimitForBooking(cancellationCharges, checkIn));
    }

    private static Date getTimeLimitForBooking(List<CancellationCharge> charges, Date dateCheckIn) {
        Date timeLimit = XtripHotelProductHelper.getTimeLimit(charges, (Date)dateCheckIn);
        return MiscUtil.addHoursToDate((Date)timeLimit, (int)-48);
    }

    private static Date getTimeLimit(HotelOffer offer, Date checkIn) {
        CancellablePolicy cancellablePolicy;
        CancellationChargeHolder chargesHolder;
        CancellationPolicy cancellationPolicy = offer.getCancellationPolicy();
        if (cancellationPolicy instanceof CancellablePolicy && (chargesHolder = (cancellablePolicy = (CancellablePolicy)cancellationPolicy).getCancellationChargesHolder()) != null) {
            return XtripHotelProductHelper.getTimeLimit((List)chargesHolder.getCancellationCharges(), (Date)checkIn);
        }
        return checkIn;
    }

    public static HotelCard convertHotelCard(Reservation reservation) {
        HotelCard result = new HotelCard();
        HotelProduct product = (HotelProduct)BookingHelper.getFirstProduct((Reservation)reservation, HotelProduct.class, null);
        if (CollectionUtil.isEmpty((Collection)product.getRooms())) {
            return result;
        }
        Room room = (Room)product.getRooms().get(0);
        result.setNumber(product.getHotelPropertyId());
        result.setName(product.getHotelName());
        result.setHotelStars(product.getHotelStars());
        result.setDescription(product.getDescription());
        LocalDate localCheckInDate = MiscUtil.toLocalDate((Date)room.getCheckInDate());
        LocalDate localCheckOutDate = MiscUtil.toLocalDate((Date)room.getCheckOutDate());
        if (localCheckInDate != null && localCheckOutDate != null) {
            result.setNumberOfNights((int)ChronoUnit.DAYS.between(localCheckInDate, localCheckOutDate));
        }
        Address address = new Address();
        address.setAddress(product.getHotelAddress());
        address.setCityInfo(HotelsConverterHelper.buildHotelCityInfo((DictionaryReference<GeoLocation>)product.getHotelLocation()));
        address.setCountry(product.getHotelCountry());
        Location loc = product.getLoc();
        if (loc != null) {
            address.setLatitude(Double.valueOf(loc.getLatitude()));
            address.setLongitude(Double.valueOf(loc.getLongitude()));
        }
        result.setAddress(address);
        Phone phone = new Phone();
        phone.setType(CommunicationType.WORK_PHONE);
        phone.setValue(product.getHotelPhone());
        result.getPhones().add(phone);
        for (String caption : product.getFacilities()) {
            Facility facility = new Facility();
            facility.setCaption(caption);
            result.getFacilities().add(facility);
        }
        return result;
    }

    public static HotelOffer buildHotelOffer(HotelProduct product) throws Exception {
        HotelOffer offer = new HotelOffer();
        offer.setGdsAccount(product.getReservation().getGdsNameInfo().getOnlineGdsAccount());
        List rooms = product.getRooms();
        if (CollectionUtil.isEmpty((Collection)rooms)) {
            return null;
        }
        Room room = (Room)rooms.get(0);
        offer.setId(room.getId());
        HotelsStayPolicy stayPolicy = new HotelsStayPolicy();
        stayPolicy.setCheckInDate(MiscUtil.toLocalDate((Date)room.getCheckInDate()));
        stayPolicy.setCheckOutDate(MiscUtil.toLocalDate((Date)room.getCheckOutDate()));
        stayPolicy.setCheckInTime(HotelsConverterHelper.convertTime(room.getCheckInTime()));
        stayPolicy.setCheckOutTime(HotelsConverterHelper.convertTime(room.getCheckOutTime()));
        stayPolicy.setStandardCheckInTime(HotelsConverterHelper.convertTime(room.getStandardCheckInTime()));
        stayPolicy.setStandardCheckOutTime(HotelsConverterHelper.convertTime(room.getStandardCheckOutTime()));
        offer.setStayPolicy(stayPolicy);
        offer.setCancellable(product.isCancellable());
        offer.setAdditionalInfo(room.getAdditionalInfo());
        offer.setHotelCardNumber(product.getHotelPropertyId());
        offer.setProviderHotelCode(product.getProviderHotelCode());
        offer.setOfferToken(room.getOfferToken());
        ProductStatus status = product.getStatus();
        offer.setFreeForSale(!product.isHotelByRequest() && status != ProductStatus.REQUEST && status != ProductStatus.REJECT);
        offer.setProvider(product.getProvider());
        offer.setStatusOffer(status);
        offer.getEssentialInfo().addAll(HotelProductHelper.getEssentialInfoValues((HotelProduct)product));
        offer.getEssentialInfoList().addAll(product.getEssentialInfoData());
        offer.setAvailability((HotelsServiceAvailability)XCloneHelper.clone((XCloneable)room.getAvailability(), (boolean)false));
        RoomInfo roomInfo = new RoomInfo();
        roomInfo.getTravellers().addAll(product.getTravellers());
        offer.setRoomInfo(roomInfo);
        offer.setRoomName(room.getRoomName());
        Meal meal = room.getMeal();
        if (meal != null) {
            com.gridnine.xtrip.common.hotels2.model.MealPlan mealPlan = new com.gridnine.xtrip.common.hotels2.model.MealPlan();
            mealPlan.setCode(meal.getCode());
            mealPlan.setCaption(meal.getCaption());
            mealPlan.setBasemealId(meal.getCode());
            offer.setMealIncluded(mealPlan);
        }
        offer.setRackRate(MoneyHelper.moneyOrNull((BigDecimal)room.getRackRate(), (String)product.getGdsCurrency()));
        offer.setCancellationPolicy(CancellationPolicyHelper.buildHotelsCancellationPolicy((HotelProduct)product));
        offer.setCancellationPolicyCostsMayChange(Boolean.TRUE.equals(product.getCancellationPolicyCostsMayChange()));
        offer.getContractRelations().addAll(ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations((BaseProduct)product));
        offer.setBlankOwnerCode(product.getBlankOwnerCode());
        offer.setSubProvider(product.getSubProvider());
        offer.setVendor(product.getGdsSubProvider());
        offer.setRateType(room.getRateType());
        offer.setBasePrice(room.getBasePrice());
        offer.getProviderVatInfo().setIncluded(room.getVat());
        offer.getProviderVatInfo().setAmount(room.getVatAmount());
        offer.getAdditionalServices().addAll(product.getAdditionalServices());
        offer.getTaxInfoList().addAll(product.getTaxInfoList());
        if (product.getStatus() == ProductStatus.INTENTION || product.getStatus() == ProductStatus.VOID_BOOKING || product.getStatus() == ProductStatus.VOID_INTENTION) {
            offer.setHotelCommission(product.getHotelAggrCommission());
        }
        return offer;
    }

    public static HotelCityInfo buildHotelCityInfo(DictionaryReference<GeoLocation> cityRef) {
        GeoLocation originCity = (GeoLocation)DictionaryCache.get().resolveReference(cityRef);
        HotelCityInfo hci = new HotelCityInfo();
        hci.setCity(cityRef);
        if (originCity != null) {
            hci.setLatitude(Double.valueOf(originCity.getLatitude()));
            hci.setLongitude(Double.valueOf(originCity.getLongitude()));
        }
        return hci;
    }

    private static LocalTime convertTime(Integer time) {
        if (null == time) {
            return null;
        }
        return LocalTime.of(time / 60, time % 60);
    }

    private static LocalDateTime convertDateTime(LocalDate date, LocalTime time) {
        if (date == null) {
            return null;
        }
        return time != null ? date.atTime(time) : date.atTime(0, 0);
    }

    public static void addWarnings(MessageContext ctx, Collection<String> warnMessages) {
        if (warnMessages != null) {
            for (final String text : warnMessages) {
                B2BRestHelper.addMessage(ctx, new InformationMessage(){

                    public InformationMessage.Severity getSeverity() {
                        return InformationMessage.Severity.WARNING;
                    }

                    public String getCode() {
                        return "hotel-warning";
                    }

                    public String getText() {
                        return text;
                    }
                });
            }
        }
    }

    public static List<com.gridnine.xtrip.common.hotels2.model.HotelCard> getHotelCards(MessageContext ctx, boolean mandatory) {
        com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCard = (com.gridnine.xtrip.common.hotels2.model.HotelCard)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD);
        if (hotelCard != null) {
            return Collections.singletonList(hotelCard);
        }
        return mandatory ? (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD_LIST) : (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD_LIST, ArrayList::new);
    }

    public static TransliterationType toTransliterationType(boolean isCyrillicNameAllowed) {
        return isCyrillicNameAllowed ? TransliterationType.LATIN_AND_CYRILLIC : TransliterationType.LATIN;
    }

    private static com.gridnine.xtrip.common.hotels2.model.HotelCard copyHotelCardWithoutOffers(com.gridnine.xtrip.common.hotels2.model.HotelCard card) {
        com.gridnine.xtrip.common.hotels2.model.HotelCard result = new com.gridnine.xtrip.common.hotels2.model.HotelCard();
        result.setName(card.getName());
        result.setNumber(card.getNumber());
        result.setAddress(card.getAddress());
        result.setLatitude(card.getLatitude());
        result.setLongitude(card.getLongitude());
        result.setCheckInTime(card.getCheckInTime());
        result.setCheckOutTime(card.getCheckOutTime());
        result.setDescription(card.getDescription());
        result.setDirectContract(card.isDirectContract());
        result.setHotelResolved(card.getHotelResolved());
        result.setHotelType(card.getHotelType());
        result.setProvider(card.getProvider());
        result.setAddress(card.getAddress());
        result.setHotelStars(card.getHotelStars());
        result.setSabreRating(card.getSabreRating());
        result.getVendorCodes().putAll(card.getVendorCodes());
        result.getProviderInfo().putAll(card.getProviderInfo());
        result.getPolicyDescriptions().addAll(card.getPolicyDescriptions());
        result.getDocuments().addAll(card.getDocuments());
        result.getFacilities().addAll(card.getFacilities());
        result.getBaseFacilities().addAll(card.getBaseFacilities());
        result.getNearLocations().addAll(card.getNearLocations());
        return result;
    }
}

