/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.bookingDataAutoCorrection;

import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.booking.BaseBookingDataAutoCorrectionProcessor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.BookingDataAutoCorrectionParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.BookingDataAutoCorrectionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelsCorrectionTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class HotelsBookingDataAutoCorrectionProcessor
extends BaseBookingDataAutoCorrectionProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingDataAutoCorrectionParameters params = (BookingDataAutoCorrectionParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)this.buildResult(params));
    }

    private BookingDataAutoCorrectionResult buildResult(BookingDataAutoCorrectionParameters params) {
        BookingDataAutoCorrectionResult result = new BookingDataAutoCorrectionResult();
        result.setTraveller(this.correctTraveller(params.getTraveller()));
        return result;
    }

    private HotelsCorrectionTraveller correctTraveller(HotelsCorrectionTraveller passenger) {
        HotelsCorrectionTraveller result = new HotelsCorrectionTraveller();
        result.setPassport(this.correctPassport(passenger.getPassport(), passenger.getLangRegistrationFullName()));
        return result;
    }

    @Override
    protected RestPassport correctPassport(RestPassport passport, TransliterationType transliterationType) {
        if (passport == null) {
            return null;
        }
        RestPassport result = new RestPassport();
        result.setLastName(this.handleName(passport.getLastName(), transliterationType));
        result.setFirstName(this.handleFirstName(passport.getFirstName(), transliterationType));
        result.setSecondName(this.handleName(passport.getSecondName(), transliterationType));
        result.setMiddleName(this.handleName(passport.getMiddleName(), transliterationType));
        return result;
    }

    @Override
    protected String handleName(String name, TransliterationType transliterationType) {
        return HotelsBookingDataAutoCorrectionProcessor.handle(name, v -> v.replaceAll("[\\s-]", ""), v -> transliterationType == TransliterationType.LATIN ? TranslitUtil.cyr2lat((String)v, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006) : v);
    }

    private String handleFirstName(String name, TransliterationType transliterationType) {
        return HotelsBookingDataAutoCorrectionProcessor.handle(name, v -> v.replaceAll("-", ""), v -> transliterationType == TransliterationType.LATIN ? TranslitUtil.cyr2lat((String)v, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006) : v);
    }
}

