/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.createIntention;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsIntentionCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.CreateIntentionParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.RoomInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class CreateIntentionParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        CreateIntentionParameters params = (CreateIntentionParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        LinkedHashMap<RoomInfo, RestHotelsOfferToken> map = new LinkedHashMap<RoomInfo, RestHotelsOfferToken>();
        RestHotelsOfferToken firstOfferToken = null;
        for (RoomInfo room : params.getRooms()) {
            RestHotelsOfferToken token = CommonRestHelper.decodeToken(room.getOffer().getToken(), RestHotelsOfferToken.class);
            if (firstOfferToken == null) {
                firstOfferToken = token;
            }
            map.put(room, token);
        }
        HotelsIntentionCreationParameters hotelsParameters = new HotelsIntentionCreationParameters();
        hotelsParameters.setGdsAccount(firstOfferToken.getOffer().getGdsAccount());
        EntityReference clientRef = salesContext.getClient();
        ArrayList travellers = new ArrayList();
        HashMap<Traveller, List<PersonCostCode>> travellersCostCodes = new HashMap<Traveller, List<PersonCostCode>>();
        for (RoomInfo room : params.getRooms()) {
            RestHotelsOfferToken token = (RestHotelsOfferToken)map.get(room);
            HotelOffer offer = token.getOffer();
            if (CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)offer)) {
                throw Xeption.forDeveloper((String)"exists HIDE by TravelPolicy offer", (Object[])new Object[0]);
            }
            if (offer.getSubagency() != null) {
                ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.SUBAGENCY_CHANGED, (Object)(!MiscUtil.equals((Object)offer.getSubagency(), (Object)salesContext.getSubagency()) ? 1 : 0));
                salesContext.setSubagency(offer.getSubagency());
            }
            hotelsParameters.setHotelCard(token.getHotelCardWithoutOffers());
            hotelsParameters.getOffers().add(offer);
            HotelsConverterHelper.updateTravellersWithCostCodes(offer, travellersCostCodes, room, (EntityReference<Organization>)clientRef);
            travellers.addAll(offer.getRoomInfo().getTravellers());
        }
        EntityStorage.get().resolve(clientRef);
        ReasonCode reasonCode = CommonConverterHelper.getReasonCode((EntityReference<Organization>)clientRef, params.getReasonCode(), ReasonCodeType.REASON_CODE_HOTEL);
        hotelsParameters.setComments(params.getComment());
        Customer customer = CommonConverterHelper.convertRest2Customer(params.getCustomer());
        Map<DictionaryReference<ExternalSystem>, String> externalSystems = B2BRestHelper.convertExternalSystems(params.getExternalSystemCodes());
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, Collections.singletonList(hotelsParameters));
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        ctx.putObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES, travellersCostCodes);
        ctx.putObject((Enum)IBusIbecorpContextKeys.REASON_CODE, (Object)reasonCode);
        ctx.putObject((Enum)IBusIbecorpContextKeys.EXTERNAL_SYSTEMS, externalSystems);
        ctx.putObject((Enum)IBusAuthorizationContextKeys.ACCEPT_PRODUCT_DUPLICATES_MESSAGE_ID, (Object)params.getAcceptProductDuplicatesMessageId());
        if (TextUtil.nonBlank((String)params.getBookingToken())) {
            AckMessage productDuplicatesMessage = B2BRestHelper.decodeToken(AckMessage.class, params.getBookingToken());
            ctx.putObject((Enum)IBusAuthorizationContextKeys.PRODUCT_DUPLICATES_MESSAGE, (Object)productDuplicatesMessage);
        }
        if (BooleanUtils.isTrue((Boolean)params.isConfirmationModeChangeAccepted())) {
            ctx.putObject((Enum)IBusHotelsContextKeys.CONFIRMATION_MODE_CHANGE_ACCEPTED, (Object)true);
        }
    }
}

