/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.createIntention;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.GuestField;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.CreateIntentionParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.CreateIntentionParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.RoomInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Traveller;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Customer;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.RailRestValidationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateIntentionValidator
extends BaseProcessor {
    private static final Set<GuestField> PASSPORT_GUEST_FIELDS = EnumSet.of(GuestField.FIRST_NAME, GuestField.SECOND_NAME, GuestField.TITLE, GuestField.CITIZENSHIP, GuestField.GUEST_BIRTH_DATE);

    public void process(MessageContext ctx) {
        ReasonCode reasonCode;
        CreateIntentionParameters params = (CreateIntentionParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMGeneralSettings settings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        SMStep3Settings step3Settings = Objects.requireNonNull(CommonHelper.getStep3Settings((EntityReference<SMSite>)siteRef));
        List rooms = params.getRooms();
        if (rooms.isEmpty()) {
            params.getValidationContext().getRoomsValidationMessages().add(CreateIntentionParametersValidationMessages.getEmptyRooms());
            this.check(params);
        }
        RestHotelsOfferToken firstToken = rooms.stream().map(r -> CommonRestHelper.decodeToken(r.getOffer().getToken(), RestHotelsOfferToken.class)).findFirst().orElse(null);
        HotelsConverterHelper.prepareContext(ctx, Objects.requireNonNull(firstToken));
        EntityReference clientRef = salesContext.getClient();
        Organization client = (Organization)EntityStorage.get().resolve(clientRef).getEntity();
        Customer customer = params.getCustomer();
        CommonValidationHelper.validateCustomer(customer, false, settings);
        for (RoomInfo room : rooms) {
            RestHotelsOfferToken token = CommonRestHelper.decodeToken(room.getOffer().getToken(), RestHotelsOfferToken.class);
            HotelOffer offer = token.getOffer();
            List travellers = room.getTravellers();
            if (travellers.isEmpty()) {
                room.getValidationContext().getTravellersValidationMessages().add(CreateIntentionParametersValidationMessages.getEmptyTravellers());
            }
            if (travellers.size() != offer.getRoomInfo().getTravellers().size()) {
                room.getValidationContext().getTravellersValidationMessages().add(CreateIntentionParametersValidationMessages.getInvalidTravellerCount());
            }
            travellers.forEach(t -> this.validateTraveller(offer, (Traveller)t, client));
        }
        List travellers = rooms.stream().flatMap(r -> r.getTravellers().stream()).collect(Collectors.toList());
        EntityContainer bfCtr = EntityStorage.get().resolve(firstToken.getBookingFile());
        RestBookingHelper.validateRestCommonCostCodes(travellers, client, (EntityContainer<BookingFile>)bfCtr);
        TravelPolicyImpositionResult travelPolicyImpositionResult = rooms.stream().map(r -> CommonRestHelper.decodeToken(r.getOffer().getToken(), RestHotelsOfferToken.class).getOffer().getTravelPolicyImpositionResult()).filter(Objects::nonNull).findFirst().orElse(null);
        if (CommonIbecorpHelper.mustHaveReasonCode((EntityReference)clientRef, (TravelPolicyImpositionResult)travelPolicyImpositionResult, (ReasonCodeType)ReasonCodeType.REASON_CODE_HOTEL) && null == (reasonCode = CommonConverterHelper.getReasonCode((EntityReference<Organization>)clientRef, params.getReasonCode(), ReasonCodeType.REASON_CODE_HOTEL))) {
            params.getValidationContext().getReasonCodeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)travelPolicyImpositionResult) && params.getKeyContact() == null) {
            params.getValidationContext().getKeyContactValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (!step3Settings.isDisablePersonalDataRules() && !params.isAcceptSecurityRules()) {
            params.getValidationContext().getAcceptSecurityRulesValidationMessages().add(CreateBookingParametersValidationMessages.getSecurityRulesNotAccepted());
        }
        this.check(params);
    }

    private void check(CreateIntentionParameters params) {
        if (!ValidationHelper.isValid((Validatable)params)) {
            throw new ValidationException();
        }
    }

    private void validateTraveller(HotelOffer offer, Traveller traveller, Organization client) {
        RestPassport passport = traveller.getPassport();
        Set mandatoryGuestFields = offer.getMandatoryGuestField();
        boolean isCyrillicNameAllowed = mandatoryGuestFields.isEmpty() || mandatoryGuestFields.stream().anyMatch(f -> GuestField.SUPPORTS_CYRILLIC_NAMES == f);
        TransliterationType transliterationType = HotelsConverterHelper.toTransliterationType(isCyrillicNameAllowed);
        boolean needPassport = CollectionUtil.containAtLeastOneCommonElement(PASSPORT_GUEST_FIELDS, (Collection)mandatoryGuestFields);
        if (needPassport && passport == null) {
            traveller.getValidationContext().getPassportValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else if (passport != null) {
            CommonValidationHelper.isValidName(passport.getFirstName(), mandatoryGuestFields.contains(GuestField.FIRST_NAME), transliterationType, true, false, false, passport.getValidationContext().getFirstNameValidationMessages());
            CommonValidationHelper.isValidName(passport.getSecondName(), false, transliterationType, true, false, false, passport.getValidationContext().getSecondNameValidationMessages());
            CommonValidationHelper.isValidName(passport.getLastName(), mandatoryGuestFields.contains(GuestField.SECOND_NAME), transliterationType, false, false, false, passport.getValidationContext().getLastNameValidationMessages());
            CommonValidationHelper.isValidName(traveller.getPassport().getMiddleName(), !traveller.getPassport().isWithoutMiddleName(), transliterationType, false, false, false, passport.getValidationContext().getMiddleNameValidationMessages());
            if (mandatoryGuestFields.contains(GuestField.TITLE) && passport.getGender() == null) {
                passport.getValidationContext().getGenderValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
            if (mandatoryGuestFields.contains(GuestField.CITIZENSHIP) && passport.getCitizenship() == null) {
                passport.getValidationContext().getCitizenshipValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
        }
        if (mandatoryGuestFields.contains(GuestField.GUEST_BIRTH_DATE) && traveller.getBirthDate() == null) {
            traveller.getValidationContext().getBirthDateValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (!TextUtil.isBlank((String)traveller.getEmail(), (boolean)false)) {
            RailRestValidationHelper.validateEmail(traveller.getEmail(), true);
        }
        if (!CommonHelper.isEmpty(traveller.getPhone())) {
            CommonValidationHelper.isValidPhone(traveller.getPhone(), traveller.getValidationContext().getPhoneValidationMessages());
        }
        RestBookingHelper.validateRestCodeCodes(traveller.getCostCodes(), client);
        Boolean isAdult = this.isAdult(traveller, offer);
        if (isAdult != null) {
            if (DictHelper.isAdultPassengerTypeCategory((DictionaryReference)traveller.getType())) {
                if (!isAdult.booleanValue()) {
                    traveller.getValidationContext().getBirthDateValidationMessages().add(CreateIntentionParametersValidationMessages.getInvalidAdultBirthday());
                }
            } else if (isAdult.booleanValue()) {
                traveller.getValidationContext().getBirthDateValidationMessages().add(CreateIntentionParametersValidationMessages.getInvalidChildBirthday());
            }
        }
    }

    private Boolean isAdult(Traveller tr, HotelOffer offer) {
        if (offer == null || tr.getPassport() == null || tr.getPassport().getBirthDate() == null || offer.getStayPolicy() == null) {
            return null;
        }
        return ChronoUnit.YEARS.between(tr.getPassport().getBirthDate(), offer.getStayPolicy().getCheckInDate()) >= 18L;
    }

    private boolean isRussia(DictionaryReference<Country> country) {
        return MiscUtil.equals((Object)DictHelper.getRuRef().getCode(), (Object)country.getCode());
    }

    private boolean isSabre(HotelOffer offer) {
        EntityContainer gdsAccountCtr = EntityStorageHelper.resolve((EntityReference)offer.getGdsAccount());
        if (gdsAccountCtr != null) {
            return ((HotelsAggregatorGdsAccount)gdsAccountCtr.getEntity()).getProvider() == HotelProvider.SABRE;
        }
        return false;
    }
}

