/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.getIntentionForm;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.GuestField;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingForm.BaseBookingFormSettingsProcessor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelIntentionFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.IntentionFormSettingsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class IntentionFormSettingsProcessor
extends BaseBookingFormSettingsProcessor {
    public void process(MessageContext ctx) throws Exception {
        HotelCard hotelCard = (HotelCard)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD);
        RestHotelsOfferToken firstToken = (RestHotelsOfferToken)ctx.getMandatoryObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_FIRST_OFFER_TOKEN);
        TravelPolicyParameters travelPolicyParams = (TravelPolicyParameters)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS);
        TripParameters tripParams = (TripParameters)ctx.getObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS);
        EntityReference currentOrgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        PersonType authUserType = (PersonType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE);
        AckMessage searchDuplicatesMessage = (AckMessage)ctx.getObject((Enum)IBusAuthorizationContextKeys.SEARCH_DUPLICATES_MESSAGE);
        boolean confirmationModeChanged = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusHotelsContextKeys.CONFIRMATION_MODE_CHANGED)));
        HotelIntentionFormSettings result = new HotelIntentionFormSettings();
        this.setSearchDuplicatesMessageData((BookingFormSettings)result, searchDuplicatesMessage);
        SalesContext salesContext = priceComponentsParameters.getSalesContext();
        boolean isAgency = MiscUtil.equals((Object)salesContext.getAgency(), (Object)currentOrgRef) || MiscUtil.equals((Object)salesContext.getSubagency(), (Object)currentOrgRef);
        EntityReference clientRef = travelPolicyParams != null ? travelPolicyParams.getClientRef() : null;
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        List persons = travelPolicyParams != null ? travelPolicyParams.getPersons() : null;
        EntityReference bookingFileRef = tripParams != null ? tripParams.getBookingFileRef() : null;
        result.setHotelCard(HotelsConverterHelper.convertHotelCardWithOffers(hotelCard, priceComponentsParameters, true, isAgency, (EntityReference<Organization>)clientRef, persons, firstToken.getRooms(), (EntityReference<BookingFile>)bookingFileRef));
        result.setContactAutocompleteAvailable(this.isContactAutocompleteAvailable(siteType, (EntityContainer<Organization>)clientCtr));
        if (persons != null) {
            EntityContainer bookingFileCont;
            BookingFile bookingFile = null;
            if (bookingFileRef != null && (bookingFileCont = EntityStorage.get().resolve(bookingFileRef)) != null) {
                bookingFile = (BookingFile)bookingFileCont.getEntity();
            }
            result.getCorporatePassengers().addAll(this.getPassengers(bookingFile, persons, Collections.emptyMap(), (EntityReference<Organization>)clientRef));
        }
        result.getOrganizationCostCodes().addAll(RestBookingHelper.getOrganizationCostCodes((EntityContainer<Organization>)clientCtr, this.getTraveller(ctx)));
        TravelPolicyImpositionResult tpImpositionResult = hotelCard.getHotelOffers().stream().map(HotelOffer::getTravelPolicyImpositionResult).filter(Objects::nonNull).findFirst().orElse(null);
        result.setReasonCode(IntentionFormSettingsProcessor.getReasonCode((EntityContainer<Organization>)clientCtr, tpImpositionResult, ReasonCodeType.REASON_CODE_HOTEL));
        IntentionFormSettingsProcessor.setKeyContact((BookingFormSettings)result, (EntityContainer<Organization>)clientCtr, tpImpositionResult);
        boolean isCyrillicNameAllowed = hotelCard.getHotelOffers().stream().allMatch(o -> o.getMandatoryGuestField().contains(GuestField.SUPPORTS_CYRILLIC_NAMES));
        TransliterationType transliterationType = HotelsConverterHelper.toTransliterationType(isCyrillicNameAllowed);
        result.setLangRegistrationFullName(transliterationType);
        result.setLangRegistrationDocument(transliterationType);
        CommonConverterHelper.setCustomerAndOrder((BookingFormSettings)result, (EntityReference<BookingFile>)bookingFileRef);
        IntentionFormSettingsProcessor.setTravellerData((BookingFormSettings)result, salesContext, TravelSubject.HOTEL_RESERVATION);
        IntentionFormSettingsProcessor.setContactPersonData((BookingFormSettings)result, authUserType, salesContext);
        if (bookingFileRef == null) {
            IntentionFormSettingsProcessor.setExternalSystemsData((BookingFormSettings)result, salesContext);
        }
        result.setConfirmationModeChanged(confirmationModeChanged);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected RestTraveller getTraveller(MessageContext ctx) {
        IntentionFormSettingsParameters params = (IntentionFormSettingsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        return params.getTraveller();
    }
}

