/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.getIntentionForm;

import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.PricingParameters;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.IntentionFormSettingsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;

public class PreparePricingParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IntentionFormSettingsParameters params = (IntentionFormSettingsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List tokens = params.getOffers().stream().map(o -> {
            BigDecimal minClientRateByNight;
            RestHotelsOfferToken token = CommonRestHelper.decodeToken(o.getToken(), RestHotelsOfferToken.class);
            BigDecimal minClientFare = o.getMinClientFare();
            token.getOffer().setMinClientPrice(minClientFare);
            if (minClientFare != null) {
                HotelOffer offer = token.getOffer();
                long nights = ChronoUnit.DAYS.between(offer.getStayPolicy().getCheckInDate(), offer.getStayPolicy().getCheckOutDate());
                minClientRateByNight = minClientFare.divide(BigDecimal.valueOf(nights), 2, 4);
            } else {
                minClientRateByNight = null;
            }
            token.getOffer().setMinClientPriceByNight(minClientRateByNight);
            return token;
        }).collect(Collectors.toList());
        List offers = tokens.stream().map(RestHotelsOfferToken::getOffer).collect(Collectors.toList());
        PricingParameters hotelParams = new PricingParameters();
        hotelParams.getOffers().addAll(offers);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_PRICING_PARAMS, (Object)hotelParams);
        RestHotelsOfferToken firstToken = (RestHotelsOfferToken)tokens.get(0);
        HotelsConverterHelper.prepareContext(ctx, firstToken);
        HotelCard tokenHotelCard = (HotelCard)XCloneHelper.clone((XCloneable)firstToken.getHotelCardWithoutOffers());
        tokenHotelCard.getHotelOffers().addAll(offers);
        ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_FIRST_OFFER_TOKEN, (Object)firstToken);
        ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_HOTEL_CARD, (Object)tokenHotelCard);
        ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_ADDITIONAL_SERVICES_CHANGED, (Object)(params.getTraveller() == null ? 1 : 0));
    }
}

