/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.pricing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.CheckInOption;
import com.gridnine.xtrip.common.hotels2.model.CheckOutOption;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOption;
import com.gridnine.xtrip.common.hotels2.model.PricingParameters;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.AdditionalServices;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.MealPlan;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.OffersPricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.RoomInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PricingParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OffersPricingParameters params = (OffersPricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (params.getRooms().isEmpty()) {
            throw Xeption.forDeveloper((String)"no rooms in request", (Object[])new Object[0]);
        }
        PricingParameters pricingParams = new PricingParameters();
        RestHotelsOfferToken firstToken = null;
        HotelCard tokenHotelCard = null;
        HashMap<Traveller, List<PersonCostCode>> travellersCostCodes = new HashMap<Traveller, List<PersonCostCode>>();
        boolean isAdditionalServicesChanged = false;
        for (RoomInfo room : params.getRooms()) {
            com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer paramOffer = room.getOffer();
            RestHotelsOfferToken token = CommonRestHelper.decodeToken(paramOffer.getToken(), RestHotelsOfferToken.class);
            if (null == firstToken) {
                firstToken = token;
                tokenHotelCard = (HotelCard)XCloneHelper.clone((XCloneable)token.getHotelCardWithoutOffers());
                HotelsConverterHelper.prepareContext(ctx, firstToken);
            }
            HotelOffer offer = token.getOffer();
            tokenHotelCard.getHotelOffers().add(offer);
            isAdditionalServicesChanged = isAdditionalServicesChanged || this.isAdditionalServicesChanged(paramOffer, offer);
            HotelsConverterHelper.updateTravellersWithCostCodes(offer, travellersCostCodes, room, (EntityReference<Organization>)salesContext.getClient());
            if (isAdditionalServicesChanged) {
                offer.getStayPolicy().setCheckInTime(offer.getStayPolicy().getStandardCheckInTime());
                offer.getStayPolicy().setCheckOutTime(offer.getStayPolicy().getStandardCheckOutTime());
                offer.getAdditionalServices().removeIf(s -> !s.isIncludedInTariff() && (s.getType() == AdditionalServiceType.EARLIER_CHECKIN || s.getType() == AdditionalServiceType.LATER_CHECKOUT || s.getType() == AdditionalServiceType.MEAL));
                AdditionalServices paramAdditionalServices = paramOffer.getAdditionalServices();
                if (paramAdditionalServices != null) {
                    LocalTime checkOut;
                    boolean isOfferDC = offer.getProvider() == HotelProvider.INTERNAL;
                    LocalTime checkIn = paramAdditionalServices.getCheckIn();
                    if (checkIn != null && !checkIn.equals(offer.getStayPolicy().getStandardCheckInTime())) {
                        boolean isCorrect = true;
                        CheckInOption option = null;
                        if (isOfferDC && null == (option = (CheckInOption)offer.getOptions().getCheckInOptions().stream().filter(o -> !(o.getFrom() != null && o.getFrom().isAfter(checkIn) || o.getTo() != null && o.getTo().isBefore(checkIn))).findFirst().orElse(null))) {
                            isCorrect = false;
                        }
                        if (isCorrect) {
                            offer.getStayPolicy().setCheckInTime(checkIn);
                            AdditionalService additionalService = new AdditionalService();
                            additionalService.setType(AdditionalServiceType.EARLIER_CHECKIN);
                            additionalService.setCount(1);
                            if (option != null) {
                                this.updateAdditionalService(additionalService, (HotelsServiceOption)option);
                            }
                            offer.getAdditionalServices().add(additionalService);
                        }
                    }
                    if ((checkOut = paramAdditionalServices.getCheckOut()) != null && !checkOut.equals(offer.getStayPolicy().getStandardCheckOutTime())) {
                        boolean isCorrect = true;
                        CheckOutOption option = null;
                        if (isOfferDC && null == (option = (CheckOutOption)offer.getOptions().getCheckOutOptions().stream().filter(o -> !(o.getFrom() != null && o.getFrom().isAfter(checkOut) || o.getTo() != null && o.getTo().isBefore(checkOut))).findFirst().orElse(null))) {
                            isCorrect = false;
                        }
                        if (isCorrect) {
                            offer.getStayPolicy().setCheckOutTime(checkOut);
                            AdditionalService additionalService = new AdditionalService();
                            additionalService.setType(AdditionalServiceType.LATER_CHECKOUT);
                            additionalService.setCount(1);
                            if (option != null) {
                                this.updateAdditionalService(additionalService, (HotelsServiceOption)option);
                            }
                            offer.getAdditionalServices().add(additionalService);
                        }
                    }
                    List meals = paramAdditionalServices.getMeals();
                    List collect = meals.stream().map(MealPlan::getUid).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty((Collection)meals)) {
                        boolean isCorrect = true;
                        HashSet options = new HashSet();
                        if (isOfferDC) {
                            offer.getOptions().getMealOptions().stream().filter(o -> !Boolean.TRUE.equals(o.getIncludedInTariff()) && collect.contains(HotelsConverterHelper.getMealCode(o))).forEach(options::add);
                            if (CollectionUtil.isEmpty(options)) {
                                isCorrect = false;
                            }
                        }
                        if (isCorrect) {
                            meals.forEach(mealPlan -> {
                                AdditionalService additionalService = new AdditionalService();
                                additionalService.setType(AdditionalServiceType.MEAL);
                                additionalService.setCode(mealPlan.getUid());
                                additionalService.setIncludedInTariff(false);
                                additionalService.setCount(1);
                                if (CollectionUtil.isNotEmpty((Collection)options)) {
                                    options.forEach(mealOption -> {
                                        this.updateAdditionalService(additionalService, (HotelsServiceOption)mealOption);
                                        additionalService.setCode(HotelsConverterHelper.getMealCode(mealOption));
                                        additionalService.setName(HotelsConverterHelper.getMealCaption(mealOption));
                                    });
                                }
                                offer.getAdditionalServices().add(additionalService);
                            });
                        }
                    }
                }
            }
            pricingParams.getOffers().add(offer);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_PRICING_PARAMS, (Object)pricingParams);
        ctx.putObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES, travellersCostCodes);
        ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_FIRST_OFFER_TOKEN, firstToken);
        ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_HOTEL_CARD, tokenHotelCard);
        ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_ADDITIONAL_SERVICES_CHANGED, (Object)isAdditionalServicesChanged);
    }

    private boolean isAdditionalServicesChanged(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer paramOffer, HotelOffer offer) {
        AdditionalServices oldServices = (AdditionalServices)MiscUtil.guarded((Object)HotelsConverterHelper.buildAdditionalServices(offer), (Object)new AdditionalServices());
        AdditionalServices newServices = (AdditionalServices)MiscUtil.guarded((Object)paramOffer.getAdditionalServices(), (Object)new AdditionalServices());
        return !MiscUtil.equals((Object)oldServices.getCheckIn(), (Object)newServices.getCheckIn()) || !MiscUtil.equals((Object)oldServices.getCheckOut(), (Object)newServices.getCheckOut()) || !this.sameMeals(oldServices.getMeals(), newServices.getMeals());
    }

    private boolean sameMeals(List<MealPlan> meals1, List<MealPlan> meals2) {
        Set uids1 = meals1.stream().map(MealPlan::getUid).collect(Collectors.toSet());
        Set uids2 = meals2.stream().map(MealPlan::getUid).collect(Collectors.toSet());
        return CollectionUtil.sameElements(uids1, uids2);
    }

    private void updateAdditionalService(AdditionalService additionalService, HotelsServiceOption option) {
        boolean includedInTariff = Boolean.TRUE.equals(option.getIncludedInTariff());
        additionalService.setIncludedInTariff(includedInTariff);
        additionalService.setStatus(AdditionalServiceStatus.REQUESTED);
        Money baseAmount = option.getPrice();
        additionalService.setBaseAmount(baseAmount);
        if (includedInTariff) {
            additionalService.setEquivalentAmount(BigDecimal.ZERO);
            additionalService.setEquivalentVatAmount(BigDecimal.ZERO);
        } else if (baseAmount != null) {
            BigDecimal equivalentAmount = MiscUtil.equals((Object)DictHelper.getLocalCurrency(), (Object)baseAmount.getCurrency(), (boolean)true) ? baseAmount.getValue() : FinanceHelper.exchange((BigDecimal)baseAmount.getValue(), (String)baseAmount.getCurrency(), (String)"RUB", (CurrencyRateType)CurrencyRateType.CBR, (TariffType)TariffType.REGULAR, (Date)new Date(), null, (boolean)true);
            additionalService.setEquivalentAmount(equivalentAmount);
            if (option.isVat() || option.getVatRate() != null) {
                double vatRate = option.getVatRate() != null ? option.getVatRate().doubleValue() : DictHelper.getDefaultVat((Date)new Date()).doubleValue();
                VatAmount va = VatAmount.of((BigDecimal)equivalentAmount, (double)vatRate);
                additionalService.setEquivalentVatAmount(va.getVatAmount());
                additionalService.setEquivalentVatRate(Double.valueOf(vatRate));
            }
        }
    }
}

