/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.searchOffers;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsToken;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.TokenRoom;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.SearchOffersRestParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.SearchOffersResult;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SearchOffersByHotelResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RestHotelsToken hotelToken;
        Map searchTokenToGdsAccount = (Map)IbusHelper.getOrDefault((MessageContext)ctx, (Enum)IBusHotelsContextKeys.HOTELS_SEARCH_TOKEN_TO_GDS_ACCOUNT, Collections::emptyMap);
        SearchOffersRestParameters restParams = (SearchOffersRestParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        EntityReference currentOrgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), salesContext);
        HotelCard hotelCard = (HotelCard)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD);
        Collection warnMessages = (Collection)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_WARNING_MESSAGES);
        TripParameters tripParams = (TripParameters)ctx.getObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS);
        SearchOffersResult result = new SearchOffersResult();
        result.setShowGdsAccountName(siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_HOTELS));
        result.setSearchFinished(hotelCard == null || searchTokenToGdsAccount.isEmpty());
        SearchOffersParameters sop = (SearchOffersParameters)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS);
        DictionaryReference originCityRef = sop.getCity();
        result.setOriginCityInfo(HotelsConverterHelper.buildHotelCityInfo((DictionaryReference<GeoLocation>)originCityRef));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        List hotelCards = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD_LIST, ArrayList::new);
        if (hotelCard == null && hotelCards.size() == 1) {
            hotelCard = (HotelCard)hotelCards.get(0);
        }
        if (hotelCard == null) {
            this.log.info("No hotel card returned during offers search");
            return;
        }
        List<TokenRoom> tokenRooms = restParams.getRooms().stream().map(HotelsConverterHelper::convertToTokenRoom).collect(Collectors.toList());
        if (!hotelCard.getHotelOffers().isEmpty()) {
            boolean isAgency = priceComponentsParameters.getSalesContext().getAgency().equals((Object)currentOrgRef) || priceComponentsParameters.getSalesContext().getSubagency().equals((Object)currentOrgRef);
            result.getHotelCards().add(HotelsConverterHelper.convertHotelCard(hotelCard, priceComponentsParameters, false, isAgency, (EntityReference<Organization>)restParams.getClient(), restParams.getRooms().stream().flatMap(r -> r.getTravellers().stream()).collect(Collectors.toList()), tokenRooms, (EntityReference<BookingFile>)restParams.getBooking(), MiscUtil.toLocalDate((Date)restParams.getCheckInDate().toDate()), MiscUtil.toLocalDate((Date)restParams.getCheckOutDate().toDate())));
            result.getHotelCards().removeIf(hc -> hc.getHotelOffers().isEmpty());
        }
        result.setTravelPolicy(TravelPolicyHelper.hasTravelPolicy(salesContext));
        if (tripParams != null) {
            result.setOrder(CommonConverterHelper.getOrder((EntityReference<BookingFile>)tripParams.getBookingFileRef()));
        }
        if ((hotelToken = (RestHotelsToken)ctx.getObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_TOKEN)) == null) {
            hotelToken = new RestHotelsToken();
        }
        hotelToken.getGdsAccountToSearchToken().clear();
        for (Map.Entry entry : searchTokenToGdsAccount.entrySet()) {
            hotelToken.getGdsAccountToSearchToken().put(((EntityContainer)entry.getKey()).toReference(), DesUtil.encode((String)((String)entry.getValue())));
        }
        hotelToken.getRooms().clear();
        hotelToken.getRooms().addAll(tokenRooms);
        if (hotelToken.getHotelCard() == null) {
            hotelCard.getHotelOffers().clear();
            hotelToken.setHotelCard(hotelCard);
        }
        result.setRestHotelToken(CommonRestHelper.encodeToken((BaseEntity)hotelToken));
        HotelsConverterHelper.addWarnings(ctx, warnMessages);
    }
}

