/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.searchOffers;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.BaseBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.SearchOffersRestParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SearchOffersParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference clientRef;
        SearchOffersRestParameters restParams = (SearchOffersRestParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchOffersParameters params = this.convertRestParameters(restParams);
        if (params.getCity() == null && TextUtil.isBlank((String)params.getHotelCardNumber())) {
            throw Xeption.forDeveloper((String)"city isn't defined", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS, (Object)params);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (restParams.getRestHotelToken() != null) {
            RestHotelsToken hotelsToken = CommonRestHelper.decodeToken(restParams.getRestHotelToken(), RestHotelsToken.class);
            ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.REST_HOTEL_TOKEN, (Object)hotelsToken);
            if (hotelsToken.getHotelCard() != null) {
                ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD, (Object)hotelsToken.getHotelCard());
            }
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_TOKEN_TO_GDS_ACCOUNT, this.getSearchTokenToGdsAccount(hotelsToken));
        }
        if ((clientRef = restParams.getClient()) != null) {
            salesContext.setClient(clientRef);
            EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
            if (clientCtr != null) {
                ((Organization)clientCtr.getEntity()).getHotelBonusCards().stream().map(BaseBonusCard::getNumber).filter(Objects::nonNull).forEach(params.getSabreNegotiatedIds()::add);
            }
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(clientRef);
            restParams.getRooms().stream().flatMap(r -> r.getTravellers().stream()).forEach(travelPolicyParams.getPersons()::add);
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
            ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, (Object)travelPolicyParams.getPersons());
        }
        if (restParams.getBooking() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(restParams.getBooking());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
    }

    private SearchOffersParameters convertRestParameters(SearchOffersRestParameters restParams) {
        HotelInfo hotelInfo;
        SearchOffersParameters result = new SearchOffersParameters();
        result.setCheckInDate(restParams.getCheckInDate().toDateTimeAtStartOfDay());
        result.setCheckOutDate(restParams.getCheckOutDate().toDateTimeAtStartOfDay());
        List roomsInfo = restParams.getRooms().stream().map(HotelsConverterHelper::convertToRoomInfo).collect(Collectors.toList());
        result.getRoomsInfo().addAll(roomsInfo);
        result.setLatitude(restParams.getLatitude());
        result.setLongitude(restParams.getLongitude());
        result.setRadius(restParams.getRadius());
        String restCityCode = restParams.getCityCode();
        if (TextUtil.nonBlank((String)restCityCode)) {
            Set cities = DictionaryCache.get().lookup(GeoLocation.class, restCityCode, new String[]{CodeSystem.HOTEL_AGGREGATOR.name()}).stream().filter(geo -> geo.getType() == LocationType.CITY).collect(Collectors.toSet());
            if (cities.isEmpty()) {
                throw Xeption.forDeveloper((String)"can't find city by HOTEL_AGGREGATOR code {0}", (Object[])new Object[]{restCityCode});
            }
            if (cities.size() > 1) {
                IncidentsLog.reportStackTrace((String)("More than one city found by code " + restCityCode));
            }
            result.setCity((DictionaryReference)((GeoLocation)cities.iterator().next()).toReference());
        }
        if ((hotelInfo = restParams.getHotelInfo()) != null) {
            result.setHotelCardNumber(hotelInfo.getHotelCardNumber());
            result.setCountry(hotelInfo.getHotelCountry());
            result.setCity(hotelInfo.getHotelCity());
        }
        return result;
    }

    private Map<EntityContainer<HotelsAggregatorGdsAccount>, String> getSearchTokenToGdsAccount(RestHotelsToken hotelsToken) throws Exception {
        HashMap<EntityContainer<HotelsAggregatorGdsAccount>, String> result = new HashMap<EntityContainer<HotelsAggregatorGdsAccount>, String>(hotelsToken.getGdsAccountToSearchToken().size());
        for (Map.Entry entry : hotelsToken.getGdsAccountToSearchToken().entrySet()) {
            EntityReference gdsAccountRef = (EntityReference)entry.getKey();
            String encryptedSearchToken = (String)entry.getValue();
            result.put((EntityContainer<HotelsAggregatorGdsAccount>)EntityStorage.get().resolve(gdsAccountRef), DesUtil.decode((String)encryptedSearchToken));
        }
        return result;
    }
}

