/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.searchOffers;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsGdsHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.Room;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.SearchOffersRestParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.SearchOffersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class SearchOffersParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFile bookingFile;
        SearchOffersRestParameters restParams = (SearchOffersRestParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference client = restParams.getClient();
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        salesContext.setClient(client);
        if (restParams.getBooking() != null && !Objects.equals((bookingFile = (BookingFile)EntityStorage.get().resolve(restParams.getBooking()).getEntity()).getCustomerProfile(), client)) {
            restParams.getValidationContext().getClientValidationMessages().add(SearchOffersValidationMessages.getWrongClientAdditionalProduct((String)bookingFile.getNumber()));
        }
        if ((restParams.getHotelInfo() == null || restParams.getHotelInfo().getHotelCardNumber() == null) && restParams.getCityCode() == null) {
            restParams.getValidationContext().getCityCodeValidationMessages().add(SearchOffersValidationMessages.getMissingHotelAndCity());
            restParams.getValidationContext().getHotelInfoValidationMessages().add(SearchOffersValidationMessages.getMissingHotelAndCity());
        }
        if (restParams.getRooms().isEmpty()) {
            throw Xeption.forDeveloper((String)"No rooms in the request", (Object[])new Object[0]);
        }
        if (((Room)restParams.getRooms().get(0)).getTravellers().isEmpty()) {
            restParams.getRooms().forEach(this::checkTravellersInfo);
        } else {
            EntityReference clientRef = restParams.getClient();
            if (clientRef == null || TextUtil.isBlank((String)clientRef.getUid())) {
                restParams.getValidationContext().getClientValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else {
                EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
                if (null == clientCtr) {
                    restParams.getValidationContext().getClientValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidClient());
                } else {
                    this.validateTravellers(restParams);
                }
            }
            HashSet<Integer> travellersNumbers = new HashSet<Integer>();
            for (Room room : restParams.getRooms()) {
                travellersNumbers.add(room.getTravellers().size());
            }
            if (travellersNumbers.size() > 1) {
                for (Room room : restParams.getRooms()) {
                    for (int i = 0; i < room.getTravellers().size(); ++i) {
                        Collection messages = CollectionUtil.getFromMap((Map)room.getValidationContext().getTravellersListValidationMessages(), (Object)i, ArrayList::new);
                        messages.add(SearchOffersValidationMessages.getDifferentGuestNumbersInRooms());
                    }
                }
            }
        }
        if (restParams.getCheckInDate() == null) {
            restParams.getValidationContext().getCheckInDateValidationMessages().add(SearchOffersValidationMessages.getMissingCheckInDate());
        }
        if (restParams.getCheckOutDate() == null) {
            restParams.getValidationContext().getCheckOutDateValidationMessages().add(SearchOffersValidationMessages.getMissingCheckOutDate());
        }
        if (HotelsGdsHelper.isSearchByRadiusEnabled((SalesContext)salesContext) && restParams.getHotelInfo() == null) {
            if (restParams.getLatitude() == null) {
                restParams.getValidationContext().getLatitudeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else if (restParams.getLatitude() == 0.0) {
                restParams.getValidationContext().getLatitudeValidationMessages().add(StandardValidationMessages.getWrongValue());
            }
            if (restParams.getLongitude() == null) {
                restParams.getValidationContext().getLongitudeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else if (restParams.getLongitude() == 0.0) {
                restParams.getValidationContext().getLongitudeValidationMessages().add(StandardValidationMessages.getWrongValue());
            }
            if (restParams.getRadius() == null) {
                restParams.getValidationContext().getRadiusValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else if (restParams.getRadius() < 5 || restParams.getRadius() > 50) {
                restParams.getValidationContext().getRadiusValidationMessages().add(SearchOffersValidationMessages.getInvalidRadiusValue((int)5, (int)50));
            }
        }
        if (!ValidationHelper.isValid((Validatable)restParams)) {
            throw new ValidationException();
        }
    }

    private void checkTravellersInfo(Room room) {
        if (MiscUtil.guarded((Integer)((Integer)room.getTravellersInfo().get(DictHelper.getAdultPassengerType()))) == 0) {
            throw Xeption.forDeveloper((String)"No adult travellers in the request", (Object[])new Object[0]);
        }
    }

    private void validateTravellers(SearchOffersRestParameters restParams) {
        EntityReference clientRef = restParams.getClient();
        EmployeeCategory employeeCategory = null;
        boolean employeeCategorySet = false;
        for (Room room : restParams.getRooms()) {
            for (int i = 0; i < room.getTravellers().size(); ++i) {
                EntityReference personRef = (EntityReference)room.getTravellers().get(i);
                EntityReference<Organization> companyRef = null;
                Person person = null;
                if (personRef != null && TextUtil.nonBlank((String)personRef.getUid())) {
                    EntityContainer personCtr = EntityStorage.get().resolve(personRef);
                    if (personCtr != null) {
                        person = (Person)personCtr.getEntity();
                        PersonEmployment personEmployment = CommonValidationHelper.getPersonEmployment(person, (EntityReference<Organization>)clientRef);
                        ValidationMessage validationDatesMessage = CommonValidationHelper.checkDatesForValid(personEmployment);
                        if (validationDatesMessage != null) {
                            room.getValidationContext().getTravellersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(validationDatesMessage);
                            continue;
                        }
                        companyRef = CommonValidationHelper.getEmployeeOrganization(person, (EntityReference<Organization>)clientRef);
                    }
                    if (!clientRef.equals(companyRef)) {
                        room.getValidationContext().getTravellersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(SearchFlightsParametersValidationMessages.getInvalidWorkPlace());
                        continue;
                    }
                    EmployeeCategory employeeCategory2 = GeneralProductHelper.getEmployeeCategory(companyRef, (Person)person);
                    if (!employeeCategorySet) {
                        employeeCategory = employeeCategory2;
                        employeeCategorySet = true;
                        continue;
                    }
                    if (GeneralProductHelper.isEmployeeCategoriesEquals((EmployeeCategory)employeeCategory, (EmployeeCategory)employeeCategory2)) continue;
                    room.getValidationContext().getTravellersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(SearchFlightsParametersValidationMessages.getInvalidPassengerEmployeeCategory());
                    continue;
                }
                room.getValidationContext().getTravellersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(SearchFlightsParametersValidationMessages.getInvalidGuest());
            }
        }
    }
}

