/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.searchPreferences;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SearchResultSortTypeProperty;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.ibecorp.assets.PersonPreferencesAsset;
import com.gridnine.xtrip.server.ibecorp.b2b.hotels.SearchRoomType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelsSearchPreferences;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class HotelsGetSearchPreferencesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference currentUser = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        HotelsSearchPreferences result = new HotelsSearchPreferences();
        PersonPreferencesAsset asset = (PersonPreferencesAsset)SearchHelper.uniqueAsset(PersonPreferencesAsset.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PersonPreferencesAsset.Property.person.name(), (Object)currentUser)});
        result.setRoomType(asset != null ? asset.getSearchRoomType() : SearchRoomType.CHEAPEST);
        if (siteType == SMSiteType.B2B) {
            result.setIssueAllowed(CabinetHelper.isBookingGranted());
            result.setApprovalAllowed(ApprovalHelper.isApprovalGranted());
        } else {
            result.setIssueAllowed(true);
            result.setApprovalAllowed(false);
        }
        result.setSearchResultSortType(SearchResultSortTypeProperty.builder((SalesContext)salesContext, (Targets)Targets.SEARCH_RESULT_SORT_TYPE_HOTEL).build());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

