/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.sendToApprove;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelsIntentionCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.TokenRoom;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.IbusIbecorpHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.HotelApproveOffer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.HotelApproveVariant;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelsSendToApproveParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class HotelsCreateIntentionParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference offerSubagency;
        HotelsSendToApproveParameters parameters = (HotelsSendToApproveParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (parameters.isSendEmail()) {
            CommonValidationHelper.validationEmailMessages(parameters.getEmails(), parameters.getValidationContext().getEmailsListValidationMessages());
        }
        if (parameters.getVariants().isEmpty()) {
            parameters.getValidationContext().getVariantsValidationMessages().add(StandardValidationMessages.getEmptyCollection());
            throw new ValidationException();
        }
        HotelApproveVariant firstVariant = (HotelApproveVariant)parameters.getVariants().get(0);
        HotelOffer firstOffer = ((HotelApproveOffer)firstVariant.getApproveOffers().get(0)).getHotelOffer();
        RestHotelsOfferToken firstToken = CommonRestHelper.decodeToken(firstOffer.getToken(), RestHotelsOfferToken.class);
        if (firstToken.getClient() != null) {
            salesContext.setClient(firstToken.getClient());
        }
        if ((offerSubagency = firstToken.getOffer().getSubagency()) != null) {
            ctx.putObject((Enum)IbusIbecorpHotelsContextKeys.SUBAGENCY_CHANGED, (Object)(!MiscUtil.equals((Object)offerSubagency, (Object)salesContext.getSubagency()) ? 1 : 0));
            salesContext.setSubagency(offerSubagency);
        }
        EntityReference bookingFile = firstToken.getBookingFile();
        EntityContainer bfCtr = EntityStorage.get().resolve(bookingFile);
        ArrayList<Traveller> availableTravellers = bfCtr != null ? new ArrayList<Traveller>(((BookingFile)bfCtr.getEntity()).getTravellers()) : new ArrayList();
        ArrayList personTravellers = new ArrayList();
        ArrayList<Traveller> emptyOfferTravellers = new ArrayList<Traveller>();
        ArrayList<Traveller> emptyTravellers = new ArrayList<Traveller>();
        firstToken.getPersons().stream().forEach(personRef -> CommonConverterHelper.getTraveller(personTravellers, availableTravellers, (EntityReference<Person>)personRef));
        if (personTravellers.isEmpty()) {
            for (int i = 0; i < firstVariant.getApproveOffers().size(); ++i) {
                HotelApproveOffer approveOffer = (HotelApproveOffer)firstVariant.getApproveOffers().get(i);
                RestHotelsOfferToken token = i == 0 ? firstToken : CommonRestHelper.decodeToken(approveOffer.getHotelOffer().getToken(), RestHotelsOfferToken.class);
                for (Traveller tr : token.getOffer().getRoomInfo().getTravellers()) {
                    Traveller traveller = CommonConverterHelper.getIfEmptyTraveller(emptyTravellers, availableTravellers);
                    traveller.setBirthday(tr.getBirthday());
                }
                if (i != 0) continue;
                emptyOfferTravellers.addAll(emptyTravellers);
            }
        }
        List rooms = firstToken.getRooms();
        ArrayList<HotelsIntentionCreationParameters> reservationCreationParameters = new ArrayList<HotelsIntentionCreationParameters>();
        for (HotelApproveVariant hotelApproveGroup : parameters.getVariants()) {
            List approveOffers = hotelApproveGroup.getApproveOffers();
            if (rooms.size() < approveOffers.size()) {
                throw Xeption.forDeveloper((String)"approve variant has {0} offers to {1} rooms", (Object[])new Object[]{approveOffers.size(), rooms.size()});
            }
            ArrayList variantTravellers = new ArrayList(personTravellers);
            int roomInd = 0;
            HotelsIntentionCreationParameters hotelsParameters = new HotelsIntentionCreationParameters();
            hotelsParameters.setGdsAccount(firstToken.getOffer().getGdsAccount());
            for (HotelApproveOffer hotelApproveOffer : approveOffers) {
                HotelOffer hotelOffer = hotelApproveOffer.getHotelOffer();
                RestHotelsOfferToken token = CommonRestHelper.decodeToken(hotelOffer.getToken(), RestHotelsOfferToken.class);
                if (!variantTravellers.isEmpty()) {
                    List roomPersons = ((TokenRoom)rooms.get(roomInd)).getSelectedTravellers();
                    if (roomPersons.isEmpty()) {
                        throw Xeption.forDeveloper((String)"persons in the room {0} are empty", (Object[])new Object[]{roomInd});
                    }
                    List offerTravellers = roomPersons.stream().map(personRef -> this.findTraveller((EntityReference<Person>)personRef, variantTravellers)).collect(Collectors.toList());
                    token.getOffer().getRoomInfo().getTravellers().clear();
                    token.getOffer().getRoomInfo().getTravellers().addAll(offerTravellers);
                } else {
                    token.getOffer().getRoomInfo().getTravellers().clear();
                    token.getOffer().getRoomInfo().getTravellers().addAll(emptyOfferTravellers);
                }
                hotelsParameters.setHotelCard(token.getHotelCardWithoutOffers());
                hotelsParameters.getOffers().add(token.getOffer());
                ++roomInd;
            }
            reservationCreationParameters.add(hotelsParameters);
        }
        ArrayList travellers = !personTravellers.isEmpty() ? personTravellers : emptyTravellers;
        Customer customer = B2BRestHelper.createCustomer((Traveller)travellers.get(0), salesContext);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        if (bookingFile != null) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.ADD_TO_BOOKING_FILE, (Object)bookingFile);
        }
        ctx.putObject((Enum)IBusIbeCorpContextKeys.IS_PROPOSAL, (Object)Boolean.TRUE);
    }

    private Traveller findTraveller(EntityReference<Person> personRef, List<Traveller> variantTravellers) {
        Traveller result = variantTravellers.stream().filter(tr -> MiscUtil.equals((Object)personRef, (Object)tr.getPassenger())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find traveller {0}", (Object[])new Object[]{personRef.getCaption()}));
        variantTravellers.remove(result);
        return result;
    }
}

