/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.sendToApprove;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.HotelApproveOffer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.HotelApproveVariant;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.Messages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SendToApproveParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SendToApproveResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelsSendToApproveParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelsSendToApproveResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.sendToApprove.SendToApprove;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class HotelsSendToApproveResultConverter
extends SendToApprove {
    @Override
    public List<String> getComments(SendToApproveParameters parameters) {
        return ((HotelsSendToApproveParameters)parameters).getVariants().stream().map(HotelApproveVariant::getApproveOffers).flatMap(Collection::stream).map(HotelApproveOffer::getComments).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public SendToApproveResult newResult() {
        return new HotelsSendToApproveResult();
    }

    @Override
    public void updateResult(EntityContainer<BookingFile> bookingFile, SendToApproveResult result, boolean subagencyChanged) throws Exception {
        if (subagencyChanged && !IbePermissionManager.isEntityGranted(bookingFile, StandardRestrictionResourceOperations.VIEW)) {
            ((HotelsSendToApproveResult)result).setSkipGetBookingInfo(true);
            result.getMessages().add(Messages.getSubagencyChangedCheckAcl());
        }
    }
}

