/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.notices;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.NoticeIndex;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetails;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.IBusRestNoticesContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.RestNoticesHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.notices.NoticesSummary;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;

public class BuildNoticeSummaryProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        List noticeIndexes = (List)ctx.getMandatoryObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_INDEXES);
        EntityContainer personNoticesCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_PERSON_DETAILS_CONTAINER);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        PersonNoticesDetails personNotices = (PersonNoticesDetails)personNoticesCtr.getEntity();
        NoticesSummary result = new NoticesSummary();
        result.setCount(noticeIndexes.size());
        result.setUnreadCount(personNotices.getUnreadNotices().size());
        noticeIndexes.stream().filter(NoticeIndex::isImportant).filter(ind -> personNotices.getUnreadNotices().contains(ind.getSource())).map(ind -> RestNoticesHelper.buildRestNotice(ind, false, generalSettings)).forEach(result.getUnreadImportant()::add);
        result.setUnreadImportantCount(result.getUnreadImportant().size());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

