/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.notices;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.Notice;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.IBusRestNoticesContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.RestNoticesHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.notices.RestNotice;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class BuildRestNoticeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer noticeCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_NOTICE_CONTAINER);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        Notice notice = (Notice)noticeCtr.getEntity();
        RestNotice result = new RestNotice();
        result.setUid(noticeCtr.getUid());
        result.setCreated(CommonHelper.getCorrectTime(notice.getCreated(), generalSettings));
        result.setImportant(notice.isImportant());
        result.setTitle(L10nStringHelper.getValue((L10nString)notice.getTitle()));
        result.setRead(RestNoticesHelper.isNoticeRead((EntityReference<Notice>)noticeCtr.toReference(), notice.getCreated(), ctx));
        result.setContent(SiteConverterHelper.getLocalizedText(notice.getContent()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

