/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.notices;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.Notice;
import com.gridnine.xtrip.common.model.ibecorp.NoticeIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.RestNoticesHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.notices.GetNoticesParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.notices.GetNoticesResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.notices.RestNoticeItem;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

public class GetAllNoticesProcessor
extends BaseProcessor {
    public static final int DEFAULT_LIMIT = 50;

    public void process(MessageContext ctx) throws Exception {
        GetNoticesParameters params = (GetNoticesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference orgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Boolean filterRead = params.isRead();
        SearchQuery query = RestNoticesHelper.buildBaseNoticeQuery((EntityReference<Organization>)orgRef, filterRead != null, ctx);
        if (params.isImportant() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)NoticeIndex.Property.important.name(), (Object)params.isImportant()));
        }
        if (params.getStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)NoticeIndex.Property.created.name(), (Object)DateUtils.toJavaDate((LocalDate)params.getStartDate())));
        }
        if (params.getEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)NoticeIndex.Property.created.name(), (Object)MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)params.getEndDate()))));
        }
        if (TextUtil.nonBlank((String)params.getPattern())) {
            query.getCriteria().setFreeTextPattern(params.getPattern());
        }
        int limit = (Integer)MiscUtil.guarded((Object)params.getPageSize(), (Object)50);
        int offset = MiscUtil.guarded((Integer)params.getPage()) * limit;
        if (filterRead == null) {
            query.setLimit(limit);
            query.setOffset(offset);
            query.setResultMode(ResultMode.DATA_AND_COUNT);
        }
        SearchResult searchResult = EntityStorage.get().search(NoticeIndex.class, query);
        List noticeIndexes = searchResult.getData();
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        GetNoticesResult result = new GetNoticesResult();
        int itemNmb = 0;
        for (NoticeIndex ind : noticeIndexes) {
            Boolean isNoticeRead = RestNoticesHelper.isNoticeRead((EntityReference<Notice>)ind.getSource(), ind.getCreated(), ctx);
            if (filterRead != null && !filterRead.equals(isNoticeRead)) continue;
            if (filterRead == null || itemNmb >= offset && result.getNotices().size() < limit) {
                RestNoticeItem restNoticeItem = RestNoticesHelper.buildRestNotice(ind, isNoticeRead, generalSettings);
                result.getNotices().add(restNoticeItem);
            }
            ++itemNmb;
        }
        if (filterRead == null) {
            result.setTotalCount(searchResult.getTotalCount());
        } else {
            result.setTotalCount(itemNmb);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

