/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.notices;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.Notice;
import com.gridnine.xtrip.common.model.ibecorp.NoticeIndex;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetails;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetailsIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.IBusRestNoticesContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.notices.RestNoticeItem;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestNoticesHelper {
    public static final String PERSON_NOTICES_DETAILS_LOCK_NAME = "PERSON_NOTICES_DETAILS";

    public static Date getMinActiveDate() {
        return MiscUtil.addMonthsToDate((Date)MiscUtil.clearTime((Date)new Date()), (int)-3);
    }

    static Date getMinDate(MessageContext ctx) {
        EntityContainer userCtr = (EntityContainer)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        EntityReference orgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        Date result = (Date)ctx.getObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_MIN_ACTIVE_DATE);
        if (result != null) {
            return result;
        }
        Date opened = ProfileHelper.getPersonEmployments((Person)((Person)userCtr.getEntity())).stream().filter(pe -> MiscUtil.equals((Object)pe.getOrganization(), (Object)orgRef)).findFirst().map(PersonEmployment::getOpened).orElse(null);
        result = MiscUtil.maximum((Date[])new Date[]{RestNoticesHelper.getMinActiveDate(), opened});
        ctx.putObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_MIN_ACTIVE_DATE, (Object)result);
        return result;
    }

    private static EntityContainer<PersonNoticesDetails> getPersonNoticesDetails(EntityReference<Person> userRef, EntityReference<Organization> orgRef) {
        EntityContainer ctr;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonNoticesDetailsIndex.Property.person.name(), userRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonNoticesDetailsIndex.Property.organization.name(), orgRef));
        PersonNoticesDetailsIndex index = (PersonNoticesDetailsIndex)CollectionUtil.singleOrNull((Collection)EntityStorage.get().search(PersonNoticesDetailsIndex.class, query).getData());
        EntityContainer entityContainer = ctr = index == null ? null : EntityStorage.get().resolve(index.getSource());
        if (ctr != null) {
            return ctr;
        }
        PersonNoticesDetails personNoticesDetails = new PersonNoticesDetails();
        personNoticesDetails.setPerson(userRef);
        personNoticesDetails.setOrganization(orgRef);
        ctr = EntityContainer.create((BaseEntity)personNoticesDetails);
        ctr.getVersionInfo().setVersionNotes("create default");
        return EntityStorage.get().save(ctr, true);
    }

    static EntityContainer<PersonNoticesDetails> getAndPutPersonNoticesDetails(MessageContext ctx) throws Exception {
        EntityContainer personNoticesCtr = (EntityContainer)ctx.getObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_PERSON_DETAILS_CONTAINER);
        if (personNoticesCtr == null) {
            EntityReference userRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
            EntityReference orgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
            String lockName = String.join((CharSequence)"_", PERSON_NOTICES_DETAILS_LOCK_NAME, LockUtil.getLockKey((EntityReference)userRef));
            personNoticesCtr = (EntityContainer)LockUtil.lock((String)lockName, () -> RestNoticesHelper.getPersonNoticesDetails((EntityReference<Person>)userRef, (EntityReference<Organization>)orgRef));
            ctx.putObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_PERSON_DETAILS_CONTAINER, (Object)personNoticesCtr);
        }
        return personNoticesCtr;
    }

    static Boolean isNoticeRead(EntityReference<Notice> noticeRef, Date created, MessageContext ctx) throws Exception {
        Date minActiveDate = RestNoticesHelper.getMinDate(ctx);
        if (minActiveDate.after(created)) {
            return null;
        }
        EntityContainer<PersonNoticesDetails> personNoticesCtr = RestNoticesHelper.getAndPutPersonNoticesDetails(ctx);
        return !((PersonNoticesDetails)personNoticesCtr.getEntity()).getUnreadNotices().contains(noticeRef);
    }

    static SearchQuery buildBaseNoticeQuery(EntityReference<Organization> orgRef, boolean excludeArchiveNotices, MessageContext ctx) {
        EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
        Organization org = (Organization)orgCtr.getEntity();
        SearchQuery query = new SearchQuery();
        if (excludeArchiveNotices) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)NoticeIndex.Property.created.name(), (Object)RestNoticesHelper.getMinDate(ctx)));
        }
        SearchCriterion orgTypeCriterion = null;
        if (org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            orgTypeCriterion = SearchCriterion.ge((String)NoticeIndex.Property.forClients.name(), (Object)true);
        } else if (org.getTypes().contains(OrganizationType.AGENCY)) {
            boolean isHeadAgency = org.getMetadata().stream().anyMatch(meta -> MetadataKey.KEY_MAIN_AGENCY.name().equals(DictHelper.getCode((DictionaryReference)meta.getKey())) && Boolean.TRUE.equals(meta.getValue()));
            orgTypeCriterion = isHeadAgency ? SearchCriterion.ge((String)NoticeIndex.Property.forHeadAgency.name(), (Object)true) : SearchCriterion.ge((String)NoticeIndex.Property.forSubagents.name(), (Object)true);
        }
        List orgCriterions = Stream.of(orgTypeCriterion, SearchCriterion.contains((String)NoticeIndex.Property.organizationUids.name(), (Object)orgCtr.getUid())).filter(Objects::nonNull).collect(Collectors.toList());
        query.getCriteria().getCriterions().add(SearchQueryHelper.toOrCriterion(orgCriterions));
        query.getCriteria().getOrders().put(NoticeIndex.Property.created.name(), SortOrder.DESC);
        return query;
    }

    static RestNoticeItem buildRestNotice(NoticeIndex ind, Boolean isRead, SMGeneralSettings generalSettings) {
        RestNoticeItem result = new RestNoticeItem();
        result.setUid(ind.getSource().getUid());
        result.setCreated(CommonHelper.getCorrectTime(ind.getCreated(), generalSettings));
        result.setTitle(L10nStringHelper.getValue((L10nString)ind.getTitle()));
        result.setImportant(ind.isImportant());
        result.setRead(isRead);
        return result;
    }
}

