/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.notices;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.NoticeIndex;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetails;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.IBusRestNoticesContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.RestNoticesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdatePersonNoticesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List noticeIndexes = (List)ctx.getMandatoryObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_INDEXES);
        EntityContainer<PersonNoticesDetails> personNoticesCtr = RestNoticesHelper.getAndPutPersonNoticesDetails(ctx);
        LockUtil.lock((EntityReference)personNoticesCtr.toReference(), ctr -> {
            boolean noticesAdded;
            PersonNoticesDetails personNoticesDetails = (PersonNoticesDetails)ctr.getEntity();
            Date lastUpdateDate = personNoticesDetails.getLastUpdateDate();
            personNoticesDetails.setLastUpdateDate(new Date());
            Map<Boolean, List<NoticeIndex>> newNoticesMap = noticeIndexes.stream().collect(Collectors.groupingBy(ind -> lastUpdateDate == null || ind.getCreated().after(lastUpdateDate)));
            Collection oldNoticeIndexes = MiscUtil.guarded((Collection)newNoticesMap.get(Boolean.FALSE));
            Collection newNoticeIndexes = MiscUtil.guarded((Collection)newNoticesMap.get(Boolean.TRUE));
            Set oldNotices = oldNoticeIndexes.stream().map(NoticeIndex::getSource).collect(Collectors.toSet());
            boolean noticesDeleted = personNoticesDetails.getUnreadNotices().retainAll(oldNotices);
            newNoticeIndexes.stream().map(NoticeIndex::getSource).forEach(personNoticesDetails.getUnreadNotices()::add);
            boolean bl = noticesAdded = !newNoticeIndexes.isEmpty();
            if (noticesDeleted | noticesAdded) {
                ctr.getVersionInfo().setVersionNotes("update unread notices");
                EntityStorage.get().save(ctr, true);
            }
            ctx.putObject((Enum)IBusRestNoticesContextKeys.REST_NOTICES_PERSON_DETAILS_CONTAINER, ctr);
        });
    }
}

