/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.statistic.helpers.CommonStatisticsHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarriageInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayServiceClassReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SearchTrainsResponse;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainSegment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CalculateMinPriceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (!CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.MIN_PRICE_RAILWAY)) {
            return;
        }
        SearchTrainsResponse result = (SearchTrainsResponse)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        Set<String> serviceClasses = result.getSpecialServiceClasses().stream().map(RailwayServiceClassReference::getUid).collect(Collectors.toSet());
        this.setMinPrices(result.getTrains(), serviceClasses);
        this.setMinPrices(result.getTrainsBack(), serviceClasses);
    }

    private void setMinPrices(List<Train> trains, Set<String> serviceClasses) {
        if (trains.isEmpty()) {
            return;
        }
        HashMap<CarriageType, Map> map = new HashMap<CarriageType, Map>();
        for (Train train : trains) {
            for (CarriageInfo carriageInfo : train.getCarriageInfos()) {
                CarriageData data = new CarriageData();
                data.startDate = this.getStartDate(train);
                data.carriageInfo = carriageInfo;
                Map m = map.computeIfAbsent(carriageInfo.getType(), t -> new HashMap());
                RailwayServiceClassReference serviceClass = carriageInfo.getServiceClass();
                List list = m.computeIfAbsent(serviceClass != null && serviceClasses.contains(serviceClass.getUid()) ? serviceClass.getUid() : null, s -> new ArrayList());
                list.add(data);
            }
        }
        map.values().stream().flatMap(v -> v.values().stream()).forEach(this::setMinPrice);
    }

    private void setMinPrice(List<CarriageData> list) {
        list.forEach(c -> c.carriageInfo.setMinPrice(this.getMinPrice((CarriageData)c, list)));
    }

    private LocalDateTime getStartDate(Train train) {
        return train.getSegments().isEmpty() ? null : ((TrainSegment)train.getSegments().get(0)).getDepartureDate();
    }

    private BigDecimal getMinPrice(CarriageData carriageData, List<CarriageData> list) {
        LocalDateTime startDate = carriageData.startDate;
        long h = list.stream().filter(cd -> cd != carriageData).mapToLong(cd -> Math.abs(ChronoUnit.HOURS.between(startDate, cd.startDate)) + 1L).min().orElse(0L);
        return list.stream().filter(cd -> Math.abs(ChronoUnit.HOURS.between(startDate, cd.startDate)) < h).map(cd -> cd.carriageInfo.getPrice()).min(BigDecimal::compareTo).orElse(null);
    }

    private static class CarriageData {
        LocalDateTime startDate;
        CarriageInfo carriageInfo;

        private CarriageData() {
        }
    }
}

