/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayStationDictionaryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardAutocompleteParams;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class GeLocationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        StandardAutocompleteParams params = (StandardAutocompleteParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        int limit = params.getLimit() == null ? 10 : params.getLimit();
        Collection<RailwayStation> stations = this.searchRailwayStations(params.getPattern(), limit);
        if (!CollectionUtil.isEmpty(stations)) {
            ctx.putObject((Enum)IBusIbecorpRailContextKeys.COLLECTION, stations);
        }
    }

    private Collection<RailwayStation> searchRailwayStations(String pattern, int limit) {
        DictionaryCache dictCache = DictionaryCache.get();
        Locale locale = LocaleManager.get().getCurrentLocale();
        String patternUpCase = pattern.toUpperCase(locale);
        TreeSet<RailwayStation> result = new TreeSet<RailwayStation>(this.createRailwayStationComparator(pattern));
        result.addAll(dictCache.lookup(RailwayStation.class, patternUpCase, new String[0]));
        HashSet searchResult = new HashSet(dictCache.search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.byDefault.name(), (Object)Boolean.TRUE)));
        searchResult.stream().filter(station -> station.getTranslations().values().stream().map(s -> s.toUpperCase(locale)).anyMatch(s -> s.indexOf(patternUpCase) != -1)).sorted(this.createRailwayStationComparator(pattern)).limit(limit).forEach(result::add);
        return result;
    }

    private Comparator<RailwayStation> createRailwayStationComparator(String pattern) {
        final String prefix = pattern.toLowerCase();
        return new Comparator<RailwayStation>(){

            @Override
            public int compare(RailwayStation o1, RailwayStation o2) {
                String oName1 = MiscUtil.guarded((String)GeLocationsProcessor.this.formatRailwayGeneralName(o1)).toLowerCase();
                String oName2 = MiscUtil.guarded((String)GeLocationsProcessor.this.formatRailwayGeneralName(o2)).toLowerCase();
                if (oName1.startsWith(prefix) && !oName2.startsWith(prefix)) {
                    return -1;
                }
                if (oName2.startsWith(prefix) && !oName1.startsWith(prefix)) {
                    return 1;
                }
                int ratingsCompare = MiscUtil.compare((Comparable)o2.getRating(), (Comparable)o1.getRating());
                if (ratingsCompare != 0) {
                    return ratingsCompare;
                }
                return oName1.compareTo(oName2);
            }
        };
    }

    public String formatRailwayGeneralName(RailwayStation station) {
        return this.formatRailwayFullName(station);
    }

    public String formatRailwayFullName(RailwayStation station) {
        String result = (String)MiscUtil.findByLocale((Map)station.getTranslations(), (Locale)LocaleManager.get().getCurrentLocale());
        if (TextUtil.isBlank((String)result)) {
            return RailwayStationDictionaryHelper.getAnyShortName((RailwayStation)station);
        }
        return result;
    }
}

