/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardAutocompleteParams;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.StationAutocompleteItem;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GeoLocationAutocompleteResponseConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection stations;
        StandardAutocompleteParams params = (StandardAutocompleteParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List<StationAutocompleteItem> result = this.composeResult(params, stations = (Collection)ctx.getObject((Enum)IBusIbecorpRailContextKeys.COLLECTION));
        if (result.size() == 1) {
            result.get(0).setComplete(true);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, result);
    }

    protected List<StationAutocompleteItem> composeResult(StandardAutocompleteParams params, Collection<RailwayStation> stations) {
        ArrayList<StationAutocompleteItem> result = new ArrayList<StationAutocompleteItem>();
        Locale locale = LocaleManager.get().getCurrentLocale();
        if (!CollectionUtil.isEmpty(stations)) {
            StationAutocompleteItem itemPrev = null;
            RailwayStation stationPrev = null;
            String prevRouteCaption = null;
            for (RailwayStation station : stations) {
                StationAutocompleteItem item = ConverterHelper.createStationAutocompleteItem(station, locale, params.getPattern());
                if (itemPrev != null && stationPrev != null && itemPrev.getCaption().equalsIgnoreCase(item.getCaption())) {
                    item.setRoute(station.getRoute());
                    String routeCaption = this.getCaptionRouteLocal(station, locale);
                    this.setCaption(item, routeCaption);
                    if (itemPrev.getRoute() == null) {
                        itemPrev.setRoute(stationPrev.getRoute());
                    }
                    if (prevRouteCaption == null) {
                        this.setCaption(itemPrev, this.getCaptionRouteLocal(stationPrev, locale));
                    } else {
                        this.setCaption(itemPrev, prevRouteCaption);
                    }
                    prevRouteCaption = routeCaption;
                } else {
                    prevRouteCaption = null;
                }
                itemPrev = item;
                stationPrev = station;
                result.add(item);
            }
        }
        return result;
    }

    private void setCaption(StationAutocompleteItem item, String caption) {
        if (caption != null) {
            item.getRoute().setCaption(caption);
        }
    }

    private String getCaptionRouteLocal(RailwayStation station, Locale locale) {
        RailwayRoute route = (RailwayRoute)DictionaryCache.get().resolveReference(station.getRoute());
        if (route == null) {
            return null;
        }
        Map translations = route.getTranslations();
        return (String)MiscUtil.findByLocale((Map)translations, (Locale)locale);
    }
}

