/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SearchFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SearchFormSettingsParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class GetSearchFormSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchFormSettingsParameters parameters = (SearchFormSettingsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        EntityReference client = parameters.getClient();
        if (client == null) {
            B2BRestHelper.getDefaultRetailClientProfileForAgency((EntityReference<Organization>)currentOrg);
        }
        salesContext.setClient(client);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)this.buildSettings(parameters, salesContext));
    }

    private SearchFormSettings buildSettings(SearchFormSettingsParameters parameters, SalesContext salesContext) throws Exception {
        SearchFormSettings result = new SearchFormSettings();
        result.setLimitDays(MiscUtil.guarded((Integer)RailwayHelper.calcDaysLimit(salesContext, (DictionaryReference<RailwayStation>)parameters.getDepartureLocation(), (DictionaryReference<RailwayStation>)parameters.getArrivalLocation())).intValue());
        result.setLimitDaysBack(MiscUtil.guarded((Integer)RailwayHelper.calcDaysLimit(salesContext, (DictionaryReference<RailwayStation>)parameters.getArrivalLocation(), (DictionaryReference<RailwayStation>)parameters.getDepartureLocation())).intValue());
        return result;
    }
}

