/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class PrepareRailwaySearchTrainsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        RzdSearchTrainsParameters res = (RzdSearchTrainsParameters)IbusHelper.getForceObject((MessageContext)ctx, (Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS, (Object)new RzdSearchTrainsParameters());
        EntityReference<Organization> client = parameters.getClient();
        if (client == null) {
            client = B2BRestHelper.getDefaultRetailClientProfileForAgency((EntityReference<Organization>)currentOrg);
        }
        salesContext.setClient(client);
        BaseRoute route = (BaseRoute)parameters.getRoutes().get(0);
        res.setDeparture(RailwayHelper.getRailwayStationDictReferenceByCode(route.getDepartureCode()));
        res.setArrival(RailwayHelper.getRailwayStationDictReferenceByCode(route.getArrivalCode()));
        res.setDepartureDate(ConverterHelper.toDate(route.getDate()));
        res.setTimeTo(Integer.valueOf(route.getDepartureTimeWindowEnd() == null ? 24 : route.getDepartureTimeWindowEnd().getHour()));
        res.setTimeFrom(Integer.valueOf(route.getDepartureTimeWindowStart() == null ? 0 : route.getDepartureTimeWindowStart().getHour()));
        res.setBusinessClass(Boolean.valueOf(parameters.getClassOfService() == ClassOfService.BUSINESS));
        if (parameters.getRouteType() == RouteType.ROUNDTRIP) {
            BaseRoute routeBack = (BaseRoute)parameters.getRoutes().get(1);
            res.setDepartureDateBack(ConverterHelper.toDate(routeBack.getDate()));
            res.setTimeToBack(Integer.valueOf(routeBack.getDepartureTimeWindowEnd() == null ? 24 : routeBack.getDepartureTimeWindowEnd().getHour()));
            res.setTimeFromBack(Integer.valueOf(routeBack.getDepartureTimeWindowStart() == null ? 0 : routeBack.getDepartureTimeWindowStart().getHour()));
        }
        if (parameters.getClient() != null) {
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(parameters.getClient());
            travelPolicyParams.getPersons().addAll(parameters.getPassengers());
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
        if (parameters.getBooking() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(parameters.getBooking());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
        res.getPassengersTypes().putAll(parameters.getPassengersTypes());
    }
}

