/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainRouteDocumentContentProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainRouteStationDocumentContentProxy;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class RailRouteDocumentContentGenerator
extends BaseProcessor {
    private static Map<String, Object> getReportParameters(TrainRouteDocumentContentProxy source) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("arrivalLocation", source.getArrivalLocation());
        parameters.put("departureLocation", source.getDepartureLocation());
        parameters.put("trainNumber", source.getTrainNumber());
        return parameters;
    }

    private static JRDataSource getDataSource(TrainRouteDocumentContentProxy source) {
        return new JRMapCollectionDataSource(RailRouteDocumentContentGenerator.getStationsList(source));
    }

    private static List<Map<String, ?>> getStationsList(TrainRouteDocumentContentProxy source) {
        ArrayList dataList = new ArrayList();
        ArrayList stationsList = new ArrayList();
        for (TrainRouteStationDocumentContentProxy station : source.getStations()) {
            HashMap<String, String> ticketDescription = new HashMap<String, String>();
            ticketDescription.put("name", station.getName());
            ticketDescription.put("arrivalTime", station.getArrivalTime());
            ticketDescription.put("stopTime", station.getStopTime());
            ticketDescription.put("departureTime", station.getDepartureTime());
            stationsList.add(ticketDescription);
        }
        HashMap stationsListDescription = new HashMap();
        stationsListDescription.put("stations", stationsList);
        dataList.add(stationsListDescription);
        return dataList;
    }

    public void process(MessageContext ctx) throws Exception {
        TrainRouteDocumentContentProxy route = (TrainRouteDocumentContentProxy)ctx.getObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY);
        List contents = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusIbecorpRailContextKeys.DOCUMENT_CONTENTS, () -> new ArrayList());
        byte[] content = this.generateContent(route);
        contents.add(Base64.encode((byte[])content));
    }

    private byte[] generateContent(TrainRouteDocumentContentProxy source) throws Exception {
        JasperReport report = JasperUtil.getReport((URL)((Object)((Object)this)).getClass().getResource("resource/railTrainRouteTemplate.jrxml"));
        Map<String, Object> params = RailRouteDocumentContentGenerator.getReportParameters(source);
        JasperPrint pdfPrint = JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)RailRouteDocumentContentGenerator.getDataSource(source));
        return JasperExportManager.exportReportToPdf((JasperPrint)pdfPrint);
    }
}

