/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainRouteParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoutePoint;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainRouteDocumentContentProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainRouteStationDocumentContentProxy;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class RailRouteDocumentProxyConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List rzdRoutes = (List)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_ROUTES);
        RzdGetTrainRouteParameters params = (RzdGetTrainRouteParameters)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_ROUTE_PARAMETERS);
        if (rzdRoutes.isEmpty()) {
            throw Xeption.forDeveloper((String)"Unable to create train route document as reservation system returned no routes.", (Object[])new Object[0]);
        }
        TrainRouteDocumentContentProxy proxy = new TrainRouteDocumentContentProxy();
        RzdRoute route = (RzdRoute)rzdRoutes.iterator().next();
        proxy.setArrivalLocation(route.getArrival());
        proxy.setDepartureLocation(route.getDeparture());
        proxy.setTrainNumber(params.getTrainNumber());
        for (RzdRoutePoint point : route.getPoints()) {
            TrainRouteStationDocumentContentProxy station = new TrainRouteStationDocumentContentProxy();
            station.setName(point.getStationName());
            station.setArrivalTime(point.getArrivalTime());
            station.setDepartureTime(point.getDepartureTime());
            if (point.getStopTime() != null) {
                station.setStopTime(String.valueOf(point.getStopTime().toMinutes()));
            }
            proxy.getStations().add(station);
        }
        ctx.putObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY, (Object)proxy);
    }
}

