/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestCarriageToken;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarPlaceData;
import com.gridnine.xtrip.common.ibecorp.rzd.model.PlacingData;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarPlaceTypeData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatRange;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatsRequest;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ReservationParamsConverter
extends BaseProcessor {
    public static RzdCar getRzdCar(RestCarriageToken restCarriageToken, RzdPrice rzdPrice) {
        for (RzdCar car : rzdPrice.getCars()) {
            if (!car.getUid().equals(restCarriageToken.getCarUid())) continue;
            return car;
        }
        throw Xeption.forDeveloper((String)"can't find car", (Object[])new Object[0]);
    }

    public void process(MessageContext ctx) throws Exception {
        PricingParameters pricingParameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMStep3Settings thirdStepSettings = Objects.requireNonNull(CommonHelper.getStep3Settings((EntityReference<SMSite>)site));
        RestTrainToken restTrainToken = (RestTrainToken)ctx.getObject("trainToken");
        RzdReservationCreationParameters creationParameters = new RzdReservationCreationParameters();
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        HashMap<Traveller, List<PersonCostCode>> travellersCostCodes = new HashMap<Traveller, List<PersonCostCode>>();
        RzdBookingSegmentParams segment = this.buildBookingSegment(pricingParameters.getRouteInfo(), thirdStepSettings);
        creationParameters.setSegment(segment);
        RzdBookingSegmentParams segmentBack = this.buildBookingSegment(pricingParameters.getRouteInfoBack(), thirdStepSettings);
        creationParameters.setSegmentBack(segmentBack);
        HashMap<RzdBookingSegmentParams, BookingRouteInfo> routeInfoMap = new HashMap<RzdBookingSegmentParams, BookingRouteInfo>();
        routeInfoMap.put(segment, pricingParameters.getRouteInfo());
        if (segmentBack != null) {
            routeInfoMap.put(segmentBack, pricingParameters.getRouteInfoBack());
        }
        ctx.putObject((Enum)IBusRailwayContextKeys.ROUTE_INFO, routeInfoMap);
        RzdBookingSegmentParams lastSegmentParams = (RzdBookingSegmentParams)MiscUtil.guarded((Object)creationParameters.getSegmentBack(), (Object)segment);
        Date arriveDate = lastSegmentParams.getTrain().getArrivalDatetime();
        EntityReference clientRef = salesContext.getClient();
        Traveller adultTraveller = null;
        for (RailTraveller railTraveller : pricingParameters.getTravellers()) {
            Traveller traveller = this.createTraveller(railTraveller, arriveDate);
            if (this.isAdult(railTraveller)) {
                adultTraveller = traveller;
                if (!railTraveller.getCostCodes().isEmpty()) {
                    List<PersonCostCode> costCodes = CorporateClientHelper.convertPersonRestCostCodes(railTraveller.getCostCodes(), (EntityReference<Organization>)clientRef, (EntityReference<Person>)traveller.getPassenger());
                    travellersCostCodes.put(traveller, costCodes);
                }
            } else if (this.isInfant(railTraveller)) {
                traveller.setParentTravellerUid(adultTraveller == null ? null : adultTraveller.getUid());
            }
            travellers.add(traveller);
            creationParameters.getRzdTravellers().add(this.createTraveller(railTraveller, traveller));
        }
        ReasonCode reasonCode = CommonConverterHelper.getReasonCode((EntityReference<Organization>)clientRef, pricingParameters.getReasonCode(), ReasonCodeType.REASON_CODE_RAIL);
        creationParameters.setGdsAccount(segment.getTrain().getGdsAccount());
        ctx.putObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES, travellersCostCodes);
        ctx.putObject((Enum)IBusIbecorpContextKeys.REASON_CODE, (Object)reasonCode);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS, (Object)creationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, Collections.singleton(creationParameters));
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusIbecorpRailContextKeys.PARSED_TOKEN, (Object)restTrainToken);
        ctx.putObject((Enum)IBusAuthorizationContextKeys.ACCEPT_PRODUCT_DUPLICATES_MESSAGE_ID, (Object)pricingParameters.getAcceptProductDuplicatesMessageId());
        if (TextUtil.nonBlank((String)pricingParameters.getBookingToken())) {
            AckMessage productDuplicatesMessage = B2BRestHelper.decodeToken(AckMessage.class, pricingParameters.getBookingToken());
            ctx.putObject((Enum)IBusAuthorizationContextKeys.PRODUCT_DUPLICATES_MESSAGE, (Object)productDuplicatesMessage);
        }
        if (restTrainToken.getBookingFile() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(restTrainToken.getBookingFile());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
        Map<DictionaryReference<ExternalSystem>, String> externalSystems = B2BRestHelper.convertExternalSystems(pricingParameters.getExternalSystemCodes());
        ctx.putObject((Enum)IBusIbecorpContextKeys.EXTERNAL_SYSTEMS, externalSystems);
    }

    protected RzdBookingSegmentParams buildBookingSegment(BookingRouteInfo routeInfo, SMStep3Settings thirdStepSettings) {
        if (routeInfo == null) {
            return null;
        }
        RestCarriageToken restCarriageToken = CommonRestHelper.decodeToken(routeInfo.getCarriage().getToken(), RestCarriageToken.class);
        RzdTrain rzdTrain = CommonRailRestHelper.convertRestToRzdTrain(routeInfo.getTrain());
        RzdPrice rzdPrice = restCarriageToken.getPrice();
        if (thirdStepSettings != null) {
            rzdPrice.getAvailableDocuments().retainAll(thirdStepSettings.getAllowedDocuments());
        }
        RzdCar rzdCar = ReservationParamsConverter.getRzdCar(restCarriageToken, rzdPrice);
        this.updateRzdCarData(rzdCar, rzdPrice, routeInfo);
        SeatsRequest seat = routeInfo.getSeatsRequest();
        RzdBookingSegmentParams result = new RzdBookingSegmentParams();
        result.setTrain(rzdTrain);
        result.setRzdPrice(rzdPrice);
        result.setRzdCar(rzdCar);
        result.setPlacing(this.buildPlacingRequirements(rzdPrice, seat, rzdCar));
        result.setPlacingData(this.buildPlacingData(routeInfo));
        result.setMinPrice(routeInfo.getCarriage().getMinPrice());
        return result;
    }

    private void updateRzdCarData(RzdCar rzdCar, RzdPrice rzdPrice, BookingRouteInfo routeInfo) {
        SeatsRequest seatsRequest = routeInfo.getSeatsRequest();
        Collection selectedCarPlaceData = routeInfo.getCarriage().getCarPlaceData().stream().filter(placeData -> placeData.getAvailableSeats().contains(String.valueOf(seatsRequest.getRange().getFirst())) || placeData.getAvailableSeats().contains(String.valueOf(seatsRequest.getRange().getSecond()))).collect(Collectors.toList());
        if (selectedCarPlaceData.isEmpty() && (seatsRequest.getRange().getFirst() == null || seatsRequest.getRange().getFirst() == null)) {
            selectedCarPlaceData = MiscUtil.guarded((Collection)routeInfo.getCarriage().getCarPlaceData());
        }
        selectedCarPlaceData.stream().findFirst().ifPresent(placeData -> {
            rzdCar.setCarPlaceType(placeData.getCarPlaceType());
            rzdPrice.setSubcategory(placeData.getSubcategory());
        });
        rzdCar.getVacantSeats().clear();
        routeInfo.getCarriage().getSeatsAvailable().stream().map(si -> si.getNumber() + (si.getGender() == null ? "" : CommonRailRestHelper.genderToString(si.getGender()))).forEach(rzdCar.getVacantSeats()::add);
    }

    private PlacingRequirements buildPlacingRequirements(RzdPrice rzdPrice, SeatsRequest seat, RzdCar rzdCar) {
        PlacingRequirements placingRequirements = new PlacingRequirements();
        if (TextUtil.isBlank((String)rzdPrice.getSubcategory()) || !rzdPrice.getSubcategory().matches(".*\u0411\u041d.*")) {
            placingRequirements.setSeatRangeFirst(seat.getRange().getFirst());
            placingRequirements.setSeatRangeLast(seat.getRange().getSecond());
            if (seat.getAmount() != null) {
                placingRequirements.setLowerSeatsCount(seat.getAmount().getLower());
                placingRequirements.setUpperSeatsCount(seat.getAmount().getUpper());
            }
        }
        placingRequirements.setKupeIndication(seat.getKupeIndication());
        placingRequirements.setGender(CommonRailRestHelper.getCompartmentType(seat.getGender()));
        if (rzdCar.isBeddingEnabled()) {
            placingRequirements.setWithBedding(Boolean.valueOf(seat.isWithBed()));
        }
        placingRequirements.setOneKupeAllSeats(seat.isOneKupeAllSeats());
        placingRequirements.setSeatsAmount(seat.getSeatsAmount());
        placingRequirements.setFullCompartment(seat.isFullCompartment());
        return placingRequirements;
    }

    private PlacingData buildPlacingData(BookingRouteInfo routeInfo) {
        SeatRange seatRange = routeInfo.getSeatsRequest().getRange();
        if (seatRange == null) {
            return null;
        }
        List selectedSeatsNumbers = IntStream.range(seatRange.getFirst(), seatRange.getSecond() + 1).boxed().map(String::valueOf).collect(Collectors.toList());
        PlacingData result = new PlacingData();
        for (CarPlaceTypeData restCarPlace : routeInfo.getCarriage().getCarPlaceData()) {
            CarPlaceData cpd = new CarPlaceData();
            cpd.setCarPlaceType(restCarPlace.getCarPlaceType());
            restCarPlace.getAvailableSeats().stream().filter(selectedSeatsNumbers::contains).forEach(cpd.getAvailableSeats()::add);
            if (cpd.getAvailableSeats().isEmpty()) continue;
            result.getCarPlaceData().add(cpd);
        }
        return result;
    }

    private boolean isInfant(RailTraveller railTraveller) {
        return DictHelper.isInfantPassengerType((DictionaryReference)railTraveller.getType());
    }

    private boolean isAdult(RailTraveller railTraveller) {
        return DictHelper.isAdultPassengerType((DictionaryReference)railTraveller.getType());
    }

    private Traveller createTraveller(RailTraveller restTraveller, Date arriveDate) {
        Traveller midofficeTraveller = CommonRailRestHelper.convertTravellerFromRest((RestTraveller)restTraveller, arriveDate);
        if (restTraveller.getRailBonusCard() != null) {
            midofficeTraveller.setRailwayBonusCard(RzdCommonHelper.createRailwayBonusCard((String)restTraveller.getRailBonusCard().getNumber()));
        }
        return midofficeTraveller;
    }

    private RzdTraveller createTraveller(RailTraveller railTraveller, Traveller traveller) {
        RzdTraveller rzdTraveller = new RzdTraveller();
        rzdTraveller.setPassengerType(railTraveller.getType());
        rzdTraveller.setTariff(railTraveller.getTariff());
        rzdTraveller.setTravellerUid(traveller.getUid());
        rzdTraveller.setNonRefundableTariff(railTraveller.isNonRefundableTariff());
        return rzdTraveller;
    }
}

