/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestCarriageToken;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarPlaceType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarPlaceTypeData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Carriage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarriageInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarriageWithReasonCodeConfiguration;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PriceInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PriceRange;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailInformationMessages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayServiceClassReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.SeatInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RestRailCarriagesHelper {
    public static List<CarriageWithReasonCodeConfiguration> convertCarriages2Rest(Train restTrain, RzdTrain rzdTrain, List<RzdPrice> prices, String carriageVariantUid, Gender filteringGender) throws Exception {
        HashMap<CarriageDataWrapper, List> carriageDataWrapperMap = new HashMap<CarriageDataWrapper, List>();
        for (RzdPrice rzdPrice : prices) {
            if (CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)rzdPrice)) continue;
            for (RzdCar rzdCar : rzdPrice.getCars()) {
                CarriageWithReasonCodeConfiguration carriage = new CarriageWithReasonCodeConfiguration();
                CommonRailRestHelper.fillCarriage((Carriage)carriage, rzdPrice, rzdCar);
                CarriageDataWrapper dataWrapper = new CarriageDataWrapper(carriage, rzdCar, rzdPrice);
                carriageDataWrapperMap.computeIfAbsent(dataWrapper, k -> new ArrayList()).add(dataWrapper);
            }
        }
        Map carriageServiceClassOrTypeMap = restTrain.getCarriageInfos().stream().collect(Collectors.toMap(carriageInfo -> carriageInfo.getServiceClass() != null ? carriageInfo.getServiceClass().getUid() : carriageInfo.getType().name(), Function.identity()));
        ArrayList<CarriageWithReasonCodeConfiguration> result = new ArrayList<CarriageWithReasonCodeConfiguration>();
        for (Map.Entry entry : carriageDataWrapperMap.entrySet()) {
            CarriageDataWrapper wrapper = (CarriageDataWrapper)entry.getKey();
            CarriageWithReasonCodeConfiguration carriage = wrapper.carriageValue;
            carriage.setCarriageVariantUid(carriageVariantUid);
            carriage.getAvailableTariffs().addAll(wrapper.rzdPrice.getAvailableTariffs());
            carriage.getAvailableDocuments().addAll(wrapper.rzdPrice.getAvailableDocuments());
            carriage.setToken(CommonRestHelper.encodeToken((BaseEntity)RestRailCarriagesHelper.getToken(wrapper.rzdPrice, wrapper.rzdCar)));
            carriage.setNonRefundableTariff(wrapper.rzdCar.isHasNonRefundableTariff());
            if (wrapper.rzdCar.getArrivalDatetime() == null || MiscUtil.equals((Object)wrapper.rzdCar.getArrivalDatetime(), (Object)rzdTrain.getArrivalDatetime())) {
                carriage.setArrivalDate(null);
                carriage.setLocalArrivalDate(null);
            }
            ((List)entry.getValue()).forEach(equivalentWrapper -> RestRailCarriagesHelper.updateCarriageData(((CarriageDataWrapper)equivalentWrapper).rzdPrice, ((CarriageDataWrapper)equivalentWrapper).rzdCar, carriage, filteringGender));
            if (carriage.getSeatsAvailable().size() == 0) continue;
            CommonConverterHelper.addTravelPolicyInfo(wrapper.rzdPrice.getTravelPolicyImpositionResult(), (HasTravelPolicyCompliance)carriage);
            CarriageInfo value = (CarriageInfo)carriageServiceClassOrTypeMap.get(carriage.getServiceClass().getUid());
            if (value == null) {
                value = (CarriageInfo)carriageServiceClassOrTypeMap.get(carriage.getType().name());
            }
            if (value != null) {
                carriage.setMinPrice(value.getMinPrice());
            }
            result.add(carriage);
        }
        return result;
    }

    private static void updateCarriageData(RzdPrice rzdPrice, RzdCar rzdCar, CarriageWithReasonCodeConfiguration carriage, Gender filteringGender) {
        RestRailCarriagesHelper.fillAvailableSeats(rzdCar, (Carriage)carriage, filteringGender);
        RestRailCarriagesHelper.fillExtraData(rzdPrice, rzdCar, (Carriage)carriage);
        RestRailCarriagesHelper.getCarriagePriceInfo((Carriage)carriage);
        RestRailCarriagesHelper.setPriceUnknown(rzdPrice, carriage);
    }

    private static void setPriceUnknown(RzdPrice rzdPrice, CarriageWithReasonCodeConfiguration carriage) {
        if (RzdCommonHelper.isPriceUnknown((RzdPriceValues)rzdPrice.getPrice())) {
            carriage.getMessages().add(RailInformationMessages.getTrailerCarUnknownPriceWarning());
        }
    }

    private static void fillExtraData(RzdPrice rzdPrice, RzdCar rzdCar, Carriage carriage) {
        carriage.setPassengerTypeChangeEnabled(Boolean.valueOf(true));
        if (rzdPrice.getSeatsIncluded() > 1) {
            if (rzdPrice.getSeatsIncluded() == 2) {
                carriage.setPassengerTypeChangeEnabled(Boolean.valueOf(false));
                if (RzdCommonHelper.isLuxWithExtraInfants((RzdPrice)rzdPrice)) {
                    carriage.setExtraChildOnly(Boolean.valueOf(true));
                }
            }
            carriage.setSeatsGroupSizeRestricted(Boolean.valueOf(true));
        }
        CarPlaceTypeData data = new CarPlaceTypeData();
        data.setPrice(RestRailCarriagesHelper.getPriceInfo(rzdPrice.getPrice()));
        data.setChildPrice(RestRailCarriagesHelper.getPriceInfo(rzdPrice.getChildPrice()));
        data.setCarPlaceType(rzdCar.getCarPlaceType() == null ? CarPlaceType.NO_VALUE : rzdCar.getCarPlaceType());
        data.setNonRefundableTariff(rzdCar.isHasNonRefundableTariff());
        data.setSubcategory(rzdPrice.getSubcategory());
        data.getAvailableSeats().addAll(rzdCar.getVacantSeats().stream().map(seat -> String.valueOf(RzdCommonHelper.seat2IntValue((String)seat))).collect(Collectors.toList()));
        carriage.getCarPlaceData().add(data);
    }

    private static void getCarriagePriceInfo(Carriage carriage) {
        Optional min = carriage.getCarPlaceData().stream().min((data1, data2) -> MiscUtil.compare((Comparable)data1.getPrice().getPriceOriginal(), (Comparable)data2.getPrice().getPriceOriginal()));
        min.ifPresent(carPlaceTypeData -> {
            carriage.setPrice(carPlaceTypeData.getPrice());
            carriage.setChildPrice(carPlaceTypeData.getChildPrice());
        });
    }

    private static RestCarriageToken getToken(RzdPrice rzdPrice, RzdCar rzdCar) {
        RestCarriageToken restCarriageToken = new RestCarriageToken();
        restCarriageToken.setCarUid(rzdCar.getUid());
        restCarriageToken.setPrice(rzdPrice);
        restCarriageToken.getAvailablePassportTypes().addAll(rzdPrice.getAvailableDocuments());
        return restCarriageToken;
    }

    private static void fillAvailableSeats(RzdCar rzdCar, Carriage carriage, Gender filteringGender) {
        Iterator seatsIt = rzdCar.getVacantSeats().iterator();
        while (seatsIt.hasNext()) {
            boolean disableSeat;
            String seat = (String)seatsIt.next();
            SeatInfo seatInfo = new SeatInfo();
            CommonRailRestHelper.fillSeatInfo(seat, seatInfo);
            Gender seatGender = RestRailCarriagesHelper.toPersonGender(seatInfo.getGender());
            boolean bl = disableSeat = filteringGender != null && seatGender != null && seatGender != filteringGender;
            if (disableSeat) {
                seatsIt.remove();
                continue;
            }
            carriage.getSeatsAvailable().add(seatInfo);
        }
    }

    private static Gender toPersonGender(com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.Gender gender) {
        if (gender == null) {
            return null;
        }
        switch (gender) {
            case MALE: {
                return Gender.MALE;
            }
            case FEMALE: {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    private static PriceInfo getPriceInfo(RzdPriceValues rzdPriceValues) {
        if (rzdPriceValues == null) {
            return null;
        }
        PriceInfo priceInfo = new PriceInfo();
        if (rzdPriceValues.getOriginalMin() != null && rzdPriceValues.getOriginalMin().compareTo(rzdPriceValues.getOriginal()) != 0) {
            priceInfo.setPriceRange(RestRailCarriagesHelper.getPriceRange(rzdPriceValues.getFullMin(), rzdPriceValues.getFull()));
            priceInfo.setPriceRangeOriginal(RestRailCarriagesHelper.getPriceRange(rzdPriceValues.getOriginalMin(), rzdPriceValues.getOriginal()));
            priceInfo.setPriceRangeGds(RestRailCarriagesHelper.getPriceRange(rzdPriceValues.getGdsPriceMin(), rzdPriceValues.getGdsPrice()));
        } else {
            priceInfo.setPrice(rzdPriceValues.getFull());
            priceInfo.setPriceOriginal(rzdPriceValues.getOriginal());
            priceInfo.setPriceGds(rzdPriceValues.getGdsPrice());
        }
        return priceInfo;
    }

    private static PriceRange getPriceRange(BigDecimal min, BigDecimal max) {
        PriceRange result = new PriceRange();
        result.setMin(min);
        result.setMax(max);
        return result;
    }

    public static Gender getFilteringGender(List<EntityReference<Person>> passengers) {
        if (CollectionUtil.isEmpty(passengers)) {
            return null;
        }
        Gender result = null;
        for (EntityReference<Person> passenger : passengers) {
            Person person;
            EntityContainer personCtr = EntityStorage.get().resolve(passenger);
            if (personCtr == null || (person = (Person)personCtr.getEntity()) == null) continue;
            if (person.getGender() == null) {
                return null;
            }
            if (result == null) {
                result = person.getGender();
                continue;
            }
            if (result == person.getGender()) continue;
            return null;
        }
        return result;
    }

    public static String getSafeUid(RailwayServiceClassReference serviceClass) {
        return serviceClass == null ? null : serviceClass.getUid();
    }

    private static String getKeyDependsOnCarriage(CarriageWithReasonCodeConfiguration carriage) {
        return carriage.getType() == null ? carriage.getServiceClass().getUid() : carriage.getType().toString();
    }

    private static class CarriageDataWrapper {
        private final String number;
        private final CarriageType type;
        private final String serviceClassUid;
        private final String carriageCardId;
        private final RzdCar rzdCar;
        private final RzdPrice rzdPrice;
        private final CarriageWithReasonCodeConfiguration carriageValue;

        private CarriageDataWrapper(CarriageWithReasonCodeConfiguration carriage, RzdCar car, RzdPrice price) {
            this.number = carriage.getNumber();
            this.type = carriage.getType();
            this.serviceClassUid = RestRailCarriagesHelper.getSafeUid(carriage.getServiceClass());
            this.carriageCardId = carriage.getCarriageCardId();
            this.rzdCar = car;
            this.rzdPrice = price;
            this.carriageValue = carriage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CarriageDataWrapper that = (CarriageDataWrapper)o;
            return Objects.equals(this.number, that.number) && this.type == that.type && Objects.equals(this.serviceClassUid, that.serviceClassUid) && Objects.equals(this.carriageCardId, that.carriageCardId);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.type, this.serviceClassUid, this.carriageCardId);
        }
    }
}

