/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrierReference;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClass;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Carriage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayServiceClassReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.TrainTimetable;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.SeatInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RestRailHelper {
    public static final Pattern weekDayPattern = Pattern.compile("(\u041f\u041e \\d{1,2}\\.\\d{1,2} )?\u041f\u041e ([1-7]+)");
    public static final Pattern untilPattern = Pattern.compile("\u041f\u041e (\\d{1,2}\\.\\d{1,2})( (\u0415\u0416|\u0427\u0415\u0422|\u041d\u0415\u0427\u0415\u0422))?");
    public static final String PRICING_BLANK_ID_PREFIX_MIN = "min-";
    public static final String PRICING_BLANK_ID_PREFIX_MAX = "max-";
    public static final Map<String, String> periods = new HashMap<String, String>();
    private static final String DATES_STRING_START = "\u0414\u0410\u0422\u042b:";
    private static final String DATES = L10nResourcesManager.getStr((String)"IBE_RAIL_TIMETABLE_DATES", (Object[])new Object[0]);
    private static final String UNTIL = L10nResourcesManager.getStr((String)"IBE_RAIL_TIMETABLE_UNTIL", (Object[])new Object[0]);
    private static String EVERY_DAY_KEY = "\u0415\u0416";

    public static TrainTimetable parseTimetable(String timetable) {
        TrainTimetable result = new TrainTimetable();
        if (timetable == null) {
            return result;
        }
        Matcher weekDayMatcher = weekDayPattern.matcher(timetable);
        if (weekDayMatcher.matches()) {
            String dayList = weekDayMatcher.group(2);
            for (int i = 0; i < dayList.length(); ++i) {
                int dayIndex = dayList.charAt(i) - 49;
                result.getDays().add(WeekDay.values()[dayIndex]);
            }
            String periodGroup = weekDayMatcher.group(1);
            String additional = !TextUtil.isBlank((String)periodGroup) ? periodGroup.substring(0, periodGroup.length() - 1).toLowerCase() : "";
            result.setAdditional(additional);
            return result;
        }
        Matcher untilMatcher = untilPattern.matcher(timetable);
        if (untilMatcher.matches()) {
            String additional;
            String untilDate = untilMatcher.group(1);
            String periodGroup = untilMatcher.group(2);
            if (!TextUtil.isBlank((String)periodGroup)) {
                String period = periods.get(periodGroup.substring(1));
                additional = period + " " + UNTIL + " " + untilDate;
            } else {
                additional = UNTIL + " " + untilDate;
            }
            result.setAdditional(additional);
            return result;
        }
        if (periods.containsKey(timetable)) {
            if (EVERY_DAY_KEY.equals(timetable)) {
                result.getDays().clear();
                result.getDays().addAll(Arrays.asList(WeekDay.values()));
            } else {
                result.setAdditional(periods.get(timetable));
            }
            return result;
        }
        result.setAdditional(RestRailHelper.translateDates(timetable));
        return result;
    }

    public static Set<RzdTariff> getAvailableTariffs(RzdTrain rzdTrain, RzdPrice rzdPrice, Carriage carriage) {
        HashSet<RzdTariff> tariffs = new HashSet<RzdTariff>(rzdPrice.getAvailableTariffs());
        if (tariffs.contains(RzdTariff.SENIOR) && RestRailHelper.isBnchSapsanMeetingRoom(rzdTrain, carriage)) {
            tariffs.remove(RzdTariff.SENIOR);
        }
        return tariffs;
    }

    private static boolean isBnchSapsanMeetingRoom(RzdTrain rzdTrain, Carriage carriage) {
        if (rzdTrain.getGds() != GdsName.TELETRAIN) {
            return false;
        }
        if (!RzdCommonHelper.isSapsan((RzdTrain)rzdTrain)) {
            return false;
        }
        Integer carriageNumber = Integer.valueOf(carriage.getNumber());
        if (carriageNumber != 11 && carriageNumber != 1) {
            return false;
        }
        boolean meetingRoom = carriage.getSeatsAvailable().stream().map(SeatInfo::getNumber).map(Integer::valueOf).anyMatch(RestRailHelper::isSapsanMeetingRoom);
        return meetingRoom;
    }

    private static boolean isSapsanMeetingRoom(int seatNumber) {
        return seatNumber == 27 || seatNumber == 28 || seatNumber == 29 || seatNumber == 30;
    }

    private static String translateDates(String timetable) {
        if (TextUtil.isBlank((String)timetable) || !timetable.startsWith(DATES_STRING_START)) {
            return timetable;
        }
        return DATES + " " + timetable.substring(DATES_STRING_START.length()).replaceAll(",", ", ");
    }

    public static List<RailwayServiceClassReference> buildSpecialServiceClasses() {
        RailwayCarrierReference dossRef = new RailwayCarrierReference("\u0414\u041e\u0421\u0421");
        Set serviceClasses = DictionaryCache.get().search(RailwayServiceClass.class, DictSearchCriterion.eq((String)RailwayServiceClass.Property.carrier.name(), (Object)dossRef));
        return serviceClasses.stream().map(CommonRailRestHelper::convertRailwayServiceClassToRest).collect(Collectors.toList());
    }

    public static List<RailTraveller> convertTravellers2Rest(Reservation reservation) {
        return CommonHelper.collectTravellers(reservation).stream().filter(Objects::nonNull).map(traveller -> RestRailHelper.convertTraveller2Rest(traveller, reservation)).collect(Collectors.toList());
    }

    public static RailTraveller convertTraveller2Rest(Traveller traveller, Reservation reservation) {
        RailTraveller railTraveller = new RailTraveller();
        CommonConverterHelper.updateRestTraveller((RestTraveller)railTraveller, traveller);
        if (traveller.getRailwayBonusCard() != null) {
            railTraveller.setRailBonusCard(CommonConverterHelper.convertRailwayBonusCard2Rest(traveller.getRailwayBonusCard()));
        }
        railTraveller.getCostCodes().addAll(CommonConverterHelper.convertCostCodesToRest(reservation, traveller));
        RestRailHelper.setTariff(reservation, traveller, railTraveller);
        RestRailHelper.setPassengerType(reservation, traveller, railTraveller);
        return railTraveller;
    }

    private static void setTariff(Reservation reservation, Traveller traveller, RailTraveller railTraveller) {
        List railwayProducts = BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayProduct.class).collect(Collectors.toList());
        for (RailwayProduct railwayProduct : railwayProducts) {
            if (!railwayProduct.getPassengers().stream().anyMatch(passenger -> passenger.getUid().equals(traveller.getUid()))) continue;
            railTraveller.setTariff(railwayProduct.getIbecorpTariff());
            railTraveller.setNonRefundableTariff(railwayProduct.isNonRefundableTariff());
            railTraveller.setSchoolTariffConfirmation(Boolean.valueOf(railwayProduct.getIbecorpTariff() == RzdTariff.SCHOOL));
        }
    }

    private static void setPassengerType(Reservation reservation, Traveller traveller, RailTraveller railTraveller) {
        PassengerTypeReference typeRef = BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayProduct.class).map(RailwayProduct::getPassengerTypes).flatMap(passengerTypeReferences -> passengerTypeReferences.stream()).filter(psr -> psr.getTraveller().getUid().equals(traveller.getUid())).findFirst().orElse(null);
        if (typeRef != null) {
            railTraveller.setType(typeRef.getPassengerType());
        }
    }

    static {
        periods.put(EVERY_DAY_KEY, L10nResourcesManager.getStr((String)"IBE_RAIL_TIMETABLE_DAILY", (Object[])new Object[0]));
        periods.put("\u0427\u0415\u0422", L10nResourcesManager.getStr((String)"IBE_RAIL_TIMETABLE_ON_AN_EVEN", (Object[])new Object[0]));
        periods.put("\u041d\u0415\u0427\u0415\u0422", L10nResourcesManager.getStr((String)"IBE_RAIL_TIMETABLE_IN_ODD", (Object[])new Object[0]));
    }
}

