/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.ibecorp.exception.NoTrainsException;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.ValidatableUtil;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Collection;
import java.util.List;

public class SearchTrainsExceptionHandler
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (e instanceof ValidationException) {
            CommonSearchParameters restParams = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
            RzdSearchTrainsParameters params = (RzdSearchTrainsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
            this.copyValidationMessages(params, restParams);
            if (ValidationHelper.isValid((Validatable)restParams)) {
                throw Xeption.forDeveloper((String)this.getValidationMessage(params), (Object[])new Object[0]);
            }
        }
        if (e instanceof NoTrainsException) {
            return true;
        }
        return super.handleException(e, ctx);
    }

    private void copyValidationMessages(RzdSearchTrainsParameters params, CommonSearchParameters restParams) {
        if (!com.gridnine.xtrip.common.model.validation.ValidationHelper.isValid((com.gridnine.xtrip.common.model.Validatable)params)) {
            RzdSearchTrainsParameters.RzdSearchTrainsParametersValidationContext vcFrom = params.getValidationContext();
            for (BaseRoute route : restParams.getRoutes()) {
                BaseRoute.BaseRouteValidationContext vcTo = route.getValidationContext();
                this.copy(vcFrom.getDepartureValidationMessages(), vcTo.getDepartureCodeValidationMessages());
                this.copy(vcFrom.getArrivalValidationMessages(), vcTo.getArrivalCodeValidationMessages());
                this.copy(vcFrom.getDepartureDateValidationMessages(), vcTo.getDateValidationMessages());
            }
        }
    }

    private void copy(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        ValidationHelper.copy(from, to);
    }

    private String getValidationMessage(RzdSearchTrainsParameters params) {
        String prefix = "params";
        List errors = ValidatableUtil.getValidateStrings((com.gridnine.xtrip.common.model.Validatable)params);
        if (errors.isEmpty()) {
            throw Xeption.forDeveloper((String)"validation advise error", (Object[])new Object[0]);
        }
        return prefix.concat(TextUtil.join((String)"; ", (Iterable)errors));
    }
}

