/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.ValidationMessages;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class SearchTrainsValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)siteRef);
        EntityReference client = parameters.getClient();
        if (client == null) {
            B2BRestHelper.getDefaultRetailClientProfileForAgency((EntityReference<Organization>)currentOrg);
        }
        salesContext.setClient(client);
        if (parameters.getRouteType() == RouteType.MULTISTOP) {
            parameters.getValidationContext().getRouteTypeValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidRouteType());
        }
        for (int i = 0; i < parameters.getPassengers().size(); ++i) {
            if (i < 4) continue;
            parameters.getValidationContext().getPassengersListValidationMessages().put(i, Collections.singletonList(SearchFlightsParametersValidationMessages.getInvalidPassengerCount()));
        }
        if (parameters.getRoutes().isEmpty()) {
            parameters.getValidationContext().getRoutesValidationMessages().add(ValidationMessages.getMissingRequiredField());
            throw Xeption.forDeveloper((String)"Missing route data", (Object[])new Object[0]);
        }
        BaseRoute route = (BaseRoute)parameters.getRoutes().get(0);
        DictionaryReference<RailwayStation> departureLocation = RailwayHelper.getRailwayStationDictReferenceByCode(route.getDepartureCode());
        DictionaryReference<RailwayStation> arrivalLocation = RailwayHelper.getRailwayStationDictReferenceByCode(route.getArrivalCode());
        Collection dateValidationMessages = route.getValidationContext().getDateValidationMessages();
        if (route.getDate() == null) {
            dateValidationMessages.add(ValidationMessages.getMissingRequiredField());
            return;
        }
        Date date = MiscUtil.clearTime((Date)route.getDate().toDate());
        RailwayHelper.validateDepartureDate(date, arrivalLocation, departureLocation, salesContext, minimumDate, dateValidationMessages, true);
        SearchTrainsValidator.validateDepartureTimeWindow(route);
        if (parameters.getRouteType() == RouteType.ROUNDTRIP) {
            if (parameters.getRoutes().size() != 2) {
                parameters.getValidationContext().getRoutesValidationMessages().add(ValidationMessages.getMissingRequiredField());
                throw Xeption.forDeveloper((String)"Missing route back data", (Object[])new Object[0]);
            }
            BaseRoute routeBack = (BaseRoute)parameters.getRoutes().get(1);
            Collection backDateValidationMessages = routeBack.getValidationContext().getDateValidationMessages();
            if (routeBack.getDate() == null) {
                backDateValidationMessages.add(ValidationMessages.getMissingRequiredField());
                return;
            }
            Date backDate = MiscUtil.clearTime((Date)routeBack.getDate().toDate());
            RailwayHelper.validateDepartureDate(backDate, arrivalLocation, departureLocation, salesContext, minimumDate, backDateValidationMessages, true);
            if (backDate.before(date)) {
                backDateValidationMessages.add(ValidationMessages.getWrongDateInterval());
            }
            SearchTrainsValidator.validateDepartureTimeWindow(routeBack);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_ENTITY, (Object)parameters);
    }

    private static void validateDepartureTimeWindow(BaseRoute route) {
        if (route.getDepartureTimeWindowStart() != null && route.getDepartureTimeWindowEnd() != null && route.getDepartureTimeWindowStart().isAfter(route.getDepartureTimeWindowEnd())) {
            route.getValidationContext().getDepartureTimeWindowStartValidationMessages().add(SearchFlightsParametersValidationMessages.getStartTimeAfterEndTime());
        }
    }
}

