/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SearchTrainsResponse;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Map;

public class TrainConverterProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdTrainWithCategories rzdTrainWithCategories = (RzdTrainWithCategories)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.GDS_TRAIN);
        SearchTrainsResponse result = (SearchTrainsResponse)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        TripParameters tripParams = (TripParameters)ctx.getObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        RzdSearchTrainsParameters gdsParams = (RzdSearchTrainsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        try {
            Train train = this.convertToRest(rzdTrainWithCategories, salesContext, parameters.getPassengers(), parameters.getPassengersTypes(), tripParams, gdsParams, siteType, generalSettings);
            if (!train.getCarriageInfos().isEmpty()) {
                if (rzdTrainWithCategories.getTrain().isTrainBack()) {
                    result.getTrainsBack().add(train);
                } else {
                    result.getTrains().add(train);
                }
            }
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)"error convert trains", (Throwable)e);
        }
    }

    private Train convertToRest(RzdTrainWithCategories rzdTrainWithCategories, SalesContext salesContext, List<EntityReference<Person>> passengers, Map<DictionaryReference<PassengerType>, Integer> passengersTypes, TripParameters tripParams, RzdSearchTrainsParameters gdsParams, SMSiteType siteType, SMGeneralSettings generalSettings) throws Exception {
        Train train = new Train();
        CommonRailRestHelper.convertRzdTrainToRest(rzdTrainWithCategories, train, (EntityReference<Organization>)salesContext.getClient(), passengers, passengersTypes, tripParams, gdsParams, siteType, generalSettings);
        return train;
    }
}

