/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainRouteParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainSegment;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDateTime;

public class TrainRoutePrepareProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Train train = (Train)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RzdGetTrainRouteParameters getTrainRouteParameters = new RzdGetTrainRouteParameters();
        if (train.getToken() == null) {
            throw Xeption.forDeveloper((String)"token is null", (Object[])new Object[0]);
        }
        RestTrainToken restTrainToken = CommonRestHelper.decodeToken(train.getToken(), RestTrainToken.class);
        if (restTrainToken.getGdsAccount() == null) {
            throw Xeption.forEndUser((String)RzdValidationMessages.getOnlyOnlineBookingAllowed().getText(), (Object[])new Object[0]);
        }
        RzdTrain rzdTrain = CommonRailRestHelper.convertRestToRzdTrain(train);
        getTrainRouteParameters.setGdsAccount(rzdTrain.getGdsAccount());
        getTrainRouteParameters.setDeparture(((TrainSegment)train.getSegments().get(0)).getDepartureLocation().getCode());
        getTrainRouteParameters.setArrival(((TrainSegment)train.getSegments().get(0)).getArrivalLocation().getCode());
        getTrainRouteParameters.setDepartureDate(DateUtils.toJavaDate((LocalDateTime)((TrainSegment)train.getSegments().get(0)).getDepartureDate()));
        getTrainRouteParameters.setTrainNumber(restTrainToken.getTrainNumber());
        salesContext.setClient(restTrainToken.getClient());
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN, (Object)rzdTrain);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_ROUTE_PARAMETERS, (Object)getTrainRouteParameters);
    }
}

