/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoutePoint;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PointInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RouteInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TrainRouteResultProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List rzdRoutes = (List)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_ROUTES);
        Collection routeInfos = (Collection)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusIbecorpRailContextKeys.TRAIN_ROUTE, () -> new ArrayList());
        if (!CollectionUtil.isEmpty((Collection)rzdRoutes)) {
            for (RzdRoute rzdRoute : rzdRoutes) {
                RouteInfo routeInfo = new RouteInfo();
                routeInfo.setArrivalLocation(rzdRoute.getArrival());
                routeInfo.setDepartureLocation(rzdRoute.getDeparture());
                routeInfo.setTitle(rzdRoute.getTitle());
                for (RzdRoutePoint rzdRoutePoint : rzdRoute.getPoints()) {
                    PointInfo pointInfo = new PointInfo();
                    pointInfo.setArrivalLocation(rzdRoutePoint.getStationName());
                    pointInfo.setArrivalTime(rzdRoutePoint.getArrivalTime());
                    pointInfo.setDepartureTime(rzdRoutePoint.getDepartureTime());
                    if (rzdRoutePoint.getStopTime() != null) {
                        pointInfo.setDurationInMinutes((int)rzdRoutePoint.getStopTime().toMinutes());
                    } else {
                        pointInfo.setDurationInMinutes(0);
                    }
                    pointInfo.setTimeDescription(rzdRoutePoint.getTimeDescription());
                    routeInfo.getPointInfos().add(pointInfo);
                }
                routeInfos.add(routeInfo);
            }
        }
    }
}

